/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="22.1.12")
@CheckID(value="R.1141")
@CheckName(value="R.1141")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.CONSTRUCTOR, RuleLabel.INITIALIZATION, RuleLabel.VERIFICATION, RuleLabel.DECLARATION_ASSIGN})
@CheckTitle(value="Initialize class variables either on declaration or in the constructor")
@CheckDescription(value="This rule checks that class fields are initialized either on declaraton or in the constructor.\nThis rule can be used as a coding guideline to indicate that the field is actually used, not just declared.\n\nExamples:\n\nclass myclass1;\n  bit checks_enable = 0; // alllowed\n  bit read_enable;       // not allowed\n  bit write_enable;      // allowed, in constructor\n\n\tfunction new(string name);\n\t\twrite_enable = 0;\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1141
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, fields of class type do not require initialization.", name="skipFieldsOfClassType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipFieldsOfClassType;
    @CheckParameter(defaultValue="false", description="When true, random fields do not require initialization.", name="skipRandomFields", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipRandomFields;
    private final Map<ParserPath, Set<RfField>> uninitializedFields = new HashMap<ParserPath, Set<RfField>>();

    public Check_R_1141(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
            this.checkClass(rfNamedElement);
        }
        for (Map.Entry entry : this.uninitializedFields.entrySet()) {
            for (RfField field : (Set)entry.getValue()) {
                this.addHit(field, "Member '" + LintUtils.getNamedElementFullName(field) + "' is not initialized upon declaration or in the constructor!");
            }
        }
        this.uninitializedFields.clear();
    }

    private void checkClass(RfNamedElement elem) {
        RfDefElement declaration = elem.getDeclaration();
        if (declaration == null) {
            return;
        }
        ParserPath path = declaration.getParserPath();
        if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this)) {
            return;
        }
        List<RfField> fields = elem.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null || fields.isEmpty()) {
            return;
        }
        this.notifyCheckAlive();
        for (RfField field : fields) {
            RfClass fieldType;
            if (field.getInitialValue(false) != null || field.isFromEmbeddedCovergroupDef() || this.pSkipFieldsOfClassType && (fieldType = LintUtils.getFieldFinalClassTypeOrNull(field)) instanceof RfClass || this.pSkipRandomFields && (field.isRand() || field.isRandc()) || field.getDataType() != null && field.getDataType().isVirtualInterface()) continue;
            Set<RfField> localFields = this.uninitializedFields.get(path);
            if (localFields == null) {
                localFields = new HashSet<RfField>();
                localFields.add(field);
                this.uninitializedFields.put(path, localFields);
                continue;
            }
            localFields.add(field);
        }
        Set<RfField> localFields = this.uninitializedFields.get(path);
        if (localFields == null || localFields.isEmpty()) {
            return;
        }
        List<RfFunction> constructors = elem.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (constructors == null || constructors.isEmpty()) {
            return;
        }
        for (RfFunction constructor : constructors) {
            constructor.visitHidObject(null, (IHidVisitor<?>)new ConstructorVisitor(null, elem));
        }
    }

    @Override
    public void clean() {
        super.clean();
        if (this.uninitializedFields != null) {
            this.uninitializedFields.clear();
        }
    }

    class ConstructorVisitor
    extends HidOperatorVisitor {
        RfNamedElement classs;

        public ConstructorVisitor(HidOperatorQualifier[] qualifiers, RfNamedElement cls) {
            super(qualifiers);
            this.classs = cls;
        }

        public boolean visit(HidOperator operator) {
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            if (lhValue == null) {
                return true;
            }
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhValue;
            IRfNamedElement element = lhHid.getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            RfClass enclosingClass = field.getEnclosingScope(RfClass.class);
            if (!this.classs.equals(enclosingClass)) {
                return true;
            }
            Set<RfField> localFields = Check_R_1141.this.uninitializedFields.get(this.parserPath);
            if (localFields == null || localFields.isEmpty()) {
                return true;
            }
            if (localFields.contains(field)) {
                localFields.remove(field);
            }
            return true;
        }
    }
}

