/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.12")
@CheckID(value="R.1142")
@CheckName(value="R.1142")
@CheckLabel(labels={RuleLabel.ASSERTION, RuleLabel.FUNCTIONAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Assertions should not have a true branch")
@CheckDescription(value="Some simulators may have optimizations that users are not aware of which will not run the true branch of an assertion.\nAlso, assertions can be disabled altogether, which may lead to unexpected behaviour.\n\nCheck supports pre-waiving.")
public class Check_R_1142
extends OVMComplianceCheck {
    public Check_R_1142(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement assertion : this.fOVMProject.getAllAssertsExpects()) {
            if (this.checkPreWaivers(assertion.getFile())) continue;
            RfAssertExpect assertionExpect = (RfAssertExpect)assertion;
            this.notifyCheckAlive();
            List<RfActionBlock> actionBlocks = assertionExpect.getLocalMembers(RfActionBlock.class);
            if (actionBlocks == null || actionBlocks.isEmpty()) continue;
            boolean skip = false;
            for (RfActionBlock actionBlock : actionBlocks) {
                if (actionBlock.isElse()) continue;
                this.addHit(assertionExpect, "Assertion " + (assertionExpect.isAnonymous() ? "" : "'" + assertionExpect.getName() + "' ") + "should not have a true branch!");
                skip = true;
            }
            if (skip) continue;
            AssertVisitor visitor = new AssertVisitor(assertionExpect);
            assertionExpect.visitHidObject(null, visitor);
            if (!visitor.hasStatement()) continue;
            this.addHit(assertionExpect, "Assertion " + (assertionExpect.isAnonymous() ? "" : "'" + assertionExpect.getName() + "' ") + "should not have a true branch!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private static class AssertVisitor
    implements IHidVisitor<IHidObject> {
        private boolean hasStatement;
        private RfNamedElement scope;
        private RfAssertExpect assertExpect;

        public AssertVisitor(RfAssertExpect assertExpect) {
            this.assertExpect = assertExpect;
        }

        /*
         * Unable to fully structure code
         */
        public boolean visit(IHidObject hidObject) {
            block6: {
                block5: {
                    if (!(hidObject instanceof RfHid)) break block5;
                    if (!((RfHid)hidObject).hasOccurrence(HidQualifier.HID_IS_STATEMENT)) {
                        return true;
                    }
                    ** GOTO lbl15
                }
                if (!(hidObject instanceof RfHidOperator)) break block6;
                if (!((RfHidOperator)hidObject).hasOccurrence(HidOperatorQualifier.IS_STATEMENT)) {
                    return true;
                }
                ** GOTO lbl15
            }
            return true;
lbl-1000:
            // 1 sources

            {
                if (this.scope instanceof RfActionBlock && ((RfActionBlock)this.scope).isElse()) {
                    return true;
                }
                this.scope = this.scope.getEnclosingScope();
lbl15:
                // 3 sources

                ** while (this.scope != null && !this.assertExpect.equals((Object)this.scope))
            }
lbl16:
            // 1 sources

            if (this.scope == null) {
                return true;
            }
            this.hasStatement = true;
            return false;
        }

        public boolean hasStatement() {
            return this.hasStatement;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

