/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;

@CheckVersion(value="22.1.16")
@CheckID(value="R.1143")
@CheckName(value="R.1143")
@CheckLabel(labels={RuleLabel.FUNCTIONAL_COVERAGE, RuleLabel.CLASS, RuleLabel.COVERGROUP, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Classes that instantiate covergroups should have a specific field")
@CheckDescription(value="If a class instantiates a covergroup, it also must have a field named <fieldName> in order to reflect its coverage functionality.\n\nCheck supports pre-waiving.")
public class Check_R_1143
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Name of class field. If empty, the class must have at least one field(excluding inheritance).", name="fieldName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pFieldName;
    @CheckParameter(defaultValue="", description="Full name of field class types that has a field named <fieldName>.", name="checkInFieldsOfType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pCheckInFieldsOfType;

    public Check_R_1143(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfField fieldWithName;
        HashSet<RfClass> fieldClasses = new HashSet<RfClass>();
        if (!this.pCheckInFieldsOfType.isEmpty() && !this.pFieldName.isEmpty()) {
            for (String className : this.pCheckInFieldsOfType) {
                RfClass fieldClass = this.fOVMProject.getRfProject().getClass(className, true);
                if (fieldClass == null) {
                    this.addHit(null, "Couldn't find class named '" + className + "'!");
                    continue;
                }
                fieldWithName = fieldClass.getFieldWithPrefix(this.pFieldName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (fieldWithName == null) {
                    this.addHit(null, "Class named '" + className + "' must have a field name '" + this.pFieldName + "'!");
                    continue;
                }
                fieldClasses.add(fieldClass);
            }
        }
        block1: for (RfClass classs : this.fOVMProject.getAllClasses()) {
            List<RfField> fields;
            if (this.checkPreWaivers(classs.getDeclaration())) continue;
            this.notifyCheckAlive();
            CovergroupInstantiationVisitor visitor = new CovergroupInstantiationVisitor(null);
            classs.visitHidObject(null, (IHidVisitor<?>)visitor);
            if (!visitor.hasCovergroupInstantiation()) continue;
            if (this.pFieldName.isEmpty()) {
                List<RfField> fields2 = classs.getFields();
                if (fields2 != null && !fields2.isEmpty()) {
                    for (RfField field : fields2) {
                        if (!field.isPredefined() && !(field.getAssociatedType() instanceof RfCovergroup)) continue block1;
                    }
                }
                this.addHit(classs, "Class '" + LintUtils.getNamedElementFullName(classs) + "' must have a field!");
                continue;
            }
            fieldWithName = classs.getFieldWithPrefix(this.pFieldName, 1, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (fieldWithName != null) continue;
            if (fieldClasses != null && !fieldClasses.isEmpty() && (fields = classs.getFieldsWithPrefix("", 2, 2, IRfNamedElement.AccessModifier.SHOW_PRIVATE)) != null && !fields.isEmpty()) {
                for (RfField field : fields) {
                    RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
                    if (!(fieldType instanceof RfClass)) continue;
                    for (RfClass fieldClass : fieldClasses) {
                        if (LintUtils.isSubClassOf((RfClass)fieldType, fieldClass)) continue block1;
                    }
                }
            }
            this.addHit(classs, "Class '" + LintUtils.getNamedElementFullName(classs) + "' must have a field named '" + this.pFieldName + "'!");
        }
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }

    private static class CovergroupInstantiationVisitor
    extends HidOperatorVisitor {
        private boolean hasCovergroupInstantiation = false;

        public CovergroupInstantiationVisitor(HidOperatorQualifier[] qualifiers) {
            super(qualifiers);
        }

        public boolean visit(HidOperator operator) {
            RfNamedElement lhType;
            if (this.hasCovergroupInstantiation) {
                return false;
            }
            if (!operator.isAssignment()) {
                return true;
            }
            IHidObject lhValue = operator.getLHValue();
            ListContainer rhValues = operator.getRHValues();
            if (!(lhValue instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhValue;
            IRfNamedElement lhElement = lhHid.getElement();
            if (lhElement instanceof RfField ? !((lhType = LintUtils.getAssociatedFinalType((RfField)lhElement)) instanceof RfCovergroup) : !(lhElement instanceof RfCovergroup)) {
                return true;
            }
            if (rhValues == null || rhValues.size() != 1) {
                return true;
            }
            if (!(rhValues.get(0) instanceof RfHidAccessArgs)) {
                return true;
            }
            RfHidAccessArgs rhHidAccessArgs = (RfHidAccessArgs)((Object)rhValues.get(0));
            Hid rhHid = rhHidAccessArgs.getParentHid();
            if (!(rhHid instanceof RfHid)) {
                return true;
            }
            IRfNamedElement rhElement = rhHid.getElement();
            if (!(rhElement instanceof RfFunction)) {
                return true;
            }
            RfFunction rhFunction = (RfFunction)rhElement;
            if (!rhFunction.isConstructor()) {
                return true;
            }
            this.hasCovergroupInstantiation = true;
            return false;
        }

        public boolean hasCovergroupInstantiation() {
            return this.hasCovergroupInstantiation;
        }
    }
}

