/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="22.1.18")
@CheckID(value="R.1144")
@CheckName(value="R.1144")
@CheckLabel(labels={RuleLabel.PORT, RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.DESIGN})
@CheckTitle(value="Port naming suffix")
@CheckDescription(value="All <elementKinds> ports must have the following suffixes: _i for input ports, _o for output ports, _io for inout ports.\n\nCheck supports pre-waiving.")
public class Check_R_1144
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="module, interface, program", description="Comma separated list of the following: module, interface, program.", name="elementKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pElementKinds;
    @CheckParameter(defaultValue="_i", description="Input port suffix.", name="inputPortSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pInputPortSuffix;
    @CheckParameter(defaultValue="_o", description="Output port suffix.", name="outputPortSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pOutputPortSuffix;
    @CheckParameter(defaultValue="_io", description="Inout port suffix.", name="inoutPortSuffix", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pInoutPortSuffix;

    public Check_R_1144(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> allElements = this.getElements();
        if (allElements == null || allElements.isEmpty()) {
            return;
        }
        for (RfNamedElement element : allElements) {
            RfInstanceHolder instanceHolder = (RfInstanceHolder)element;
            if (this.checkPreWaivers(instanceHolder.getDeclaration())) continue;
            this.notifyCheckAlive();
            List<IRfPortElement> allPorts = instanceHolder.getLocalPorts();
            for (IRfPortElement port : allPorts) {
                if (port.isInout() && !port.getName().endsWith(this.pInoutPortSuffix)) {
                    this.addHit(instanceHolder, "Inout port '" + port.getName() + "' of '" + LintUtils.getNamedElementFullName(instanceHolder) + "' doesn't end with '" + this.pInoutPortSuffix + "'!");
                    continue;
                }
                if (port.isInput() && !port.getName().endsWith(this.pInputPortSuffix)) {
                    this.addHit(instanceHolder, "Input port '" + port.getName() + "' of '" + LintUtils.getNamedElementFullName(instanceHolder) + "' doesn't end with '" + this.pInputPortSuffix + "'!");
                    continue;
                }
                if (!port.isOutput() || port.getName().endsWith(this.pOutputPortSuffix)) continue;
                this.addHit(instanceHolder, "Output port '" + port.getName() + "' of '" + LintUtils.getNamedElementFullName(instanceHolder) + "' doesn't end with '" + this.pOutputPortSuffix + "'!");
            }
        }
    }

    private NullProtectedList<RfNamedElement> getElements() {
        NullProtectedList<RfNamedElement> elements = new NullProtectedList<RfNamedElement>();
        if (this.pElementKinds.contains("module")) {
            elements.addAll(this.fOVMProject.getAllModules());
        }
        if (this.pElementKinds.contains("interface")) {
            elements.addAll(this.fOVMProject.getAllInterfaces());
        }
        if (this.pElementKinds.contains("program")) {
            elements.addAll(this.fOVMProject.getAllPrograms());
        }
        return elements;
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }
}

