/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayDeque;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="22.1.19")
@CheckID(value="R.1145")
@CheckName(value="R.1145")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.CONDITIONAL, RuleLabel.IF, RuleLabel.ALWAYS, RuleLabel.DESIGN})
@CheckTitle(value="If blocks must have else in always")
@CheckDescription(value="All if blocks declared inside an always block must have an else block in order to clarify the design intent.\n\nCheck supports pre-waiving.")
public class Check_R_1145
extends OVMComplianceCheck {
    public Check_R_1145(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlockList = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : actionBlockList) {
            RfFileDef file;
            if (actionBlock == null || !actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value()) || (file = actionBlock.getFile()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            this.handleActionBlock(actionBlock);
        }
    }

    private void handleActionBlock(RfActionBlock actionBlock) {
        List<RfActionBlock> actionBlockMembers = actionBlock.getLocalMembers(RfActionBlock.class);
        if (actionBlockMembers == null || actionBlockMembers.isEmpty()) {
            return;
        }
        ArrayDeque<RfActionBlock> blocksWithoutMatchingElse = new ArrayDeque<RfActionBlock>();
        for (RfActionBlock member : actionBlockMembers) {
            if (member.isIf()) {
                blocksWithoutMatchingElse.add(member);
            }
            if (!member.isElse() || blocksWithoutMatchingElse.isEmpty()) continue;
            blocksWithoutMatchingElse.pollLast();
        }
        if (!blocksWithoutMatchingElse.isEmpty()) {
            for (RfActionBlock block : blocksWithoutMatchingElse) {
                this.addHit(block, "If block doesn't have an else!");
            }
        }
        for (RfActionBlock block : actionBlockMembers) {
            this.handleActionBlock(block);
        }
    }
}

