/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;

@CheckVersion(value="22.1.19")
@CheckID(value="R.1146")
@CheckName(value="R.1146")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.PARAMETER, RuleLabel._4_STATE})
@CheckTitle(value="Parameter type must be two state type")
@CheckDescription(value="This check verifies that all parameters are two state types in order to avoid the possibility of having X or Z bits in constants.\n\nCheck supports pre-waiving.")
public class Check_R_1146
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="parameter, localparam", description="Comma separated list of the following: parameter, localparam.", name="parameterType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pParameterType;
    private boolean checkParameter;
    private boolean checkLocalParameter;

    public Check_R_1146(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkParameter = this.pParameterType.contains("parameter");
        this.checkLocalParameter = this.pParameterType.contains("localparam");
        this.fOVMProject.getRfProject().accept(new LocalNamedElementVisitor());
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }

    class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        LocalNamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)namedElement;
            Check_R_1146.this.notifyCheckAlive();
            if (Check_R_1146.this.checkPreWaivers(field.getFile())) {
                return true;
            }
            if (!field.isParameter()) {
                return true;
            }
            if (Check_R_1146.this.checkParameter && !field.isLocalParameter() || Check_R_1146.this.checkLocalParameter && field.isLocalParameter()) {
                if (field.isTypeParameter()) {
                    return true;
                }
                if (field.isParameterNoDataType()) {
                    Check_R_1146.this.addHit(field, "Parameter '" + LintUtils.getNamedElementFullName(field) + "' has four state type!");
                    return true;
                }
                RfNamedElement dataType = LintUtils.getAssociatedFinalType((RfField)namedElement, RfTypesResolver.create((IRfScopeElement)namedElement.getEnclosingScope(), Check_R_1146.this.fOVMProject.getRfProject(), 6));
                if (!LintUtils.isFourStateType(dataType, true)) {
                    return true;
                }
                Check_R_1146.this.addHit(field, "Parameter '" + LintUtils.getNamedElementFullName(field) + "' has four state type!");
            }
            return true;
        }
    }
}

