/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="22.1.19")
@CheckID(value="R.1147")
@CheckName(value="R.1147")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.ALWAYS, RuleLabel.DESIGN})
@CheckTitle(value="Do not use sequential blocks in always_comb, always_latch, always_ff")
@CheckDescription(value="This check verifies there are no begin end blocks in always_comb, always_latch, always_ff blocks in order to prevent introducing sequential dependencies.\n\nCheck supports pre-waiving.")
public class Check_R_1147
extends OVMComplianceCheck {
    public Check_R_1147(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlockList = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : actionBlockList) {
            RfFileDef file;
            if (actionBlock == null || !actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_FF.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value()) || (file = actionBlock.getFile()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfActionBlock> actionBlockMembers = actionBlock.getLocalMembers(RfActionBlock.class);
            if (actionBlockMembers == null || actionBlockMembers.isEmpty()) continue;
            for (RfActionBlock member : actionBlockMembers) {
                member.accept(null, new LocalNamedElementVisitor());
            }
        }
    }

    class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        LocalNamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfActionBlock)) {
                return true;
            }
            RfActionBlock block = (RfActionBlock)namedElement;
            if (!block.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.BEGIN_END)) {
                return true;
            }
            Check_R_1147.this.addHit(block, "Forbidden sequential block!");
            return true;
        }
    }
}

