/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.ExplicitImportInfo;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="22.1.19")
@CheckID(value="R.1148")
@CheckName(value="R.1148")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.IMPORT, RuleLabel.PERFORMANCE})
@CheckTitle(value="Unused package import")
@CheckDescription(value="Importing in packages unnecesary packages or types may pollute the namespace and affect the performance.\n\nExample:\nimport A_package::*;  // not allowed if no type from A_package is used\nimport B_package::B_class;  // not allowed if B_class is not used\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1148
extends OVMComplianceCheck {
    public Check_R_1148(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfPackage pkg : this.fOVMProject.getAllPackages()) {
            NullProtectedList<ImportInfo> packageImports = pkg.getAllImportDeclarations();
            if (packageImports == null || packageImports.isEmpty()) continue;
            this.notifyCheckAlive();
            LocalNamedElementVisitor typeVisitor = new LocalNamedElementVisitor(pkg);
            pkg.accept(null, typeVisitor);
            HidVisitor fieldsVisitor = new HidVisitor(pkg);
            pkg.visitHidObject(null, fieldsVisitor);
            Map<RfPackage, Set<RfNamedElement>> usedImportElementTypes = typeVisitor.getUsedImportedElements();
            Map<RfPackage, Set<RfNamedElement>> usedImportElementFields = fieldsVisitor.getUsedImportedElements();
            for (ImportInfo packageImport : packageImports) {
                IRfPackageElement importedPackage = packageImport.getPackage();
                if (packageImport instanceof ExplicitImportInfo) {
                    ExplicitImportInfo explicitImport = (ExplicitImportInfo)packageImport;
                    IRfNamedElement importedElement = explicitImport.getElement();
                    Set<RfNamedElement> usedElements = usedImportElementTypes.get(importedPackage);
                    if (usedElements != null && !usedElements.isEmpty() && usedElements.contains(importedElement) || (usedElements = usedImportElementFields.get(importedPackage)) != null && !usedElements.isEmpty() && usedElements.contains(importedElement)) continue;
                    if (importedElement instanceof IRfAssociatedTypeElement) {
                        RfNamedElement importedElementType = LintUtils.getAssociatedFinalType((IRfAssociatedTypeElement)importedElement);
                        usedElements = usedImportElementTypes.get(importedPackage);
                        if (usedElements != null && !usedElements.isEmpty() && usedElements.contains(importedElementType)) continue;
                    }
                    this.addHit(packageImport.getParserPath(), packageImport.getLine(), "Unused imported element: '" + packageImport.getPackageName() + "::" + importedElement.getName() + "'!", null);
                    continue;
                }
                Set<RfNamedElement> usedElements = usedImportElementTypes.get(importedPackage);
                if (usedElements != null && !usedElements.isEmpty() || (usedElements = usedImportElementFields.get(importedPackage)) != null && !usedElements.isEmpty()) continue;
                this.addHit(packageImport.getParserPath(), packageImport.getLine(), "Unused import from '" + packageImport.getPackageName() + "::*'!", null);
            }
        }
    }

    private static void addElement(Map<RfPackage, Set<RfNamedElement>> allElements, RfPackage scope, RfNamedElement element) {
        Set<RfNamedElement> importedElements = allElements.get(scope);
        if (importedElements == null) {
            importedElements = new HashSet<RfNamedElement>();
            importedElements.add(element);
            allElements.put(scope, importedElements);
        } else {
            importedElements.add(element);
        }
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }

    private class HidVisitor
    extends RfHidVisitor {
        private RfPackage packageScope;
        private Map<RfPackage, Set<RfNamedElement>> usedImportedElements;

        public HidVisitor(RfPackage packageScope) {
            this.packageScope = packageScope;
            this.usedImportedElements = new HashMap<RfPackage, Set<RfNamedElement>>();
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfNamedElement)) {
                return true;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            Check_R_1148.this.notifyCheckAlive();
            RfPackage elementPackage = namedElement.getEnclosingPackage();
            if (elementPackage == null || elementPackage.equals(this.packageScope)) {
                return true;
            }
            Check_R_1148.addElement(this.usedImportedElements, elementPackage, namedElement);
            return true;
        }

        public Map<RfPackage, Set<RfNamedElement>> getUsedImportedElements() {
            return this.usedImportedElements;
        }
    }

    class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        private RfPackage packageScope;
        private Map<RfPackage, Set<RfNamedElement>> usedImportedElements;

        public LocalNamedElementVisitor(RfPackage packageScope) {
            this.packageScope = packageScope;
            this.usedImportedElements = new HashMap<RfPackage, Set<RfNamedElement>>();
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            RfPackage elementPackage;
            RfNamedElement assocType;
            if (Check_R_1148.this.checkPreWaivers(namedElement.getDeclaration())) {
                return true;
            }
            if (namedElement instanceof RfPredefinedFunction || namedElement instanceof RfPredefinedField || namedElement instanceof RfResultImplicitVariable) {
                return true;
            }
            Check_R_1148.this.notifyCheckAlive();
            if (namedElement instanceof RfClass) {
                List<RfClass> parentInterfaces;
                RfClass classs = (RfClass)namedElement;
                HashSet<RfClass> classesToBeChecked = new HashSet<RfClass>();
                RfClass parent = classs.getParent();
                if (parent != null) {
                    classesToBeChecked.add(parent);
                }
                if ((parentInterfaces = classs.getParentInterfaces()) != null) {
                    classesToBeChecked.addAll(parentInterfaces);
                }
                for (RfClass classToBeChecked : classesToBeChecked) {
                    RfPackage classPackage = classToBeChecked.getEnclosingPackage();
                    if (classPackage == null || this.packageScope.equals(classPackage)) continue;
                    Check_R_1148.addElement(this.usedImportedElements, classPackage, classToBeChecked);
                }
                return true;
            }
            if (namedElement instanceof RfStruct && ((RfStruct)namedElement).isEnum()) {
                this.visit(new RfAssociatedTypeWrapper(((RfStruct)namedElement).getEnumBaseDataType(), namedElement));
            }
            if ((assocType = this.getElementType(namedElement)) instanceof RfSpecializedClass) {
                RfSpecializedClass specializedClass = (RfSpecializedClass)assocType;
                for (IELParamValue parameter : specializedClass.getLocalElabConstantValues().values()) {
                    RfPackage parameterScope;
                    IRfNamedElement parameterElement = parameter.getNamedElement();
                    if (!(parameterElement instanceof RfNamedElement) || (parameterScope = ((RfNamedElement)parameterElement).getEnclosingPackage()) == null || this.packageScope.equals(parameterScope)) continue;
                    Check_R_1148.addElement(this.usedImportedElements, parameterScope, (RfNamedElement)parameterElement);
                }
            }
            if ((elementPackage = assocType.getEnclosingPackage()) == null || this.packageScope.equals(elementPackage)) {
                return true;
            }
            Check_R_1148.addElement(this.usedImportedElements, elementPackage, assocType);
            return true;
        }

        private RfNamedElement getElementType(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfAssociatedType)) {
                return namedElement;
            }
            IRfNamedElement elementType = ((RfAssociatedType)namedElement).getAssociatedTypeNoLastLevelParams();
            while (elementType instanceof RfListType) {
                elementType = ((RfListType)elementType).getAssociatedTypeNoLastLevelParams();
            }
            if (!(elementType instanceof RfNamedElement)) {
                return namedElement;
            }
            RfNamedElement assocType = (RfNamedElement)elementType;
            return assocType;
        }

        public Map<RfPackage, Set<RfNamedElement>> getUsedImportedElements() {
            return this.usedImportedElements;
        }
    }
}

