/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="22.1.19")
@CheckID(value="R.1149")
@CheckName(value="R.1149")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.INTERFACE, RuleLabel.MONITOR, RuleLabel.DRIVER, RuleLabel.VERIFICATION})
@CheckTitle(value="Access interfaces only in monitors and drivers")
@CheckDescription(value="This check flags read and write operations done on interfaces in classes that are not monitors or drivers.\n\nCheck supports pre-waiving.")
public class Check_R_1149
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of interface names that should not be accessed. If empty, all interface accesses are forbidden.", name="interfaceNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pInterfaceNames;

    public Check_R_1149(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(new LocalNamedElementVisitor());
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;
        private IRfNamedElement scope;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHid hid) {
            String typeName;
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)element;
            RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field, RfTypesResolver.create((IRfScopeElement)this.scope, this.scope.getRfProject(), 6));
            if (!(fieldType instanceof RfInterface)) {
                return true;
            }
            if (!Check_R_1149.this.pInterfaceNames.isEmpty() && !Check_R_1149.this.pInterfaceNames.contains(typeName = fieldType.getName())) {
                return true;
            }
            Check_R_1149.this.addHit(this.parserPath, hid, "Forbidden interface access '" + HidUtils.toNiceString((IHidObject)hid) + "'!");
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = ((RfHidHolder)holder).getScope();
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        LocalNamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            if (!(namedElement instanceof RfClass)) {
                return true;
            }
            RfClass classs = (RfClass)namedElement;
            if (Check_R_1149.this.checkPreWaivers(classs.getDeclaration())) {
                return true;
            }
            if (Check_R_1149.this.fOVMProject.isDriver(classs) || Check_R_1149.this.fOVMProject.isMonitor(classs)) {
                return true;
            }
            Check_R_1149.this.notifyCheckAlive();
            classs.visitHidObject(null, new LocalHidVisitor());
            return true;
        }
    }
}

