/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="22.1.20")
@CheckID(value="R.1150")
@CheckName(value="R.1150")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.NAME, RuleLabel.PREDEFINED_METHOD, RuleLabel.SHADOWING})
@CheckTitle(value="Do not define methods with the same name as system functions.")
@CheckDescription(value="Function and task names must be different from system function names, otherwise some tools might confuse them with system functions.\n\nCheck supports pre-waiving.")
public class Check_R_1150
extends OVMComplianceCheck {
    private Set<String> systemFunctions = new HashSet<String>(Arrays.asList("finish", "exit", "fatal", "warning", "stop", "error", "info", "realtime", "time", "asserton", "assertkill", "assertpasson", "assertfailon", "assertnonvacuouson", "stime", "printtimescale", "timeformat", "bitstoreal", "bitstoshortreal", "itor", "signed", "cast", "realtobits", "shortrealtobits", "rtoi", "unsigned", "sampled", "fell", "changed", "past_gclk", "fell_gclk", "changed_gclk", "rising_gclk", "steady_gclk", "bits", "typename", "isunbounded", "coverage_control", "coverage_get", "coverage_save", "set_coverage_db_name", "dimensions", "right", "high", "size", "random", "dist_erlang", "dist_normal", "dist_t", "asin", "acos", "atan", "atan2", "hypot", "sinh", "cosh", "tanh", "asinh", "acosh", "atanh", "q_initialize", "q_remove", "q_exam", "q_add", "q_full", "asyncandarray", "asyncnandarray", "asyncorarray", "asyncnorarray", "syncandarray", "syncnandarray", "syncorarray", "syncnorarray", "countones", "onehot0", "fatal", "warning", "dist_chi_square", "dist_exponential", "dist_poisson", "dist_uniform", "countbits", "onehot", "isunknown", "coverage_get_max", "coverage_merge", "get_coverage", "load_coverage_db", "clog2", "ln", "log10", "exp", "sqrt", "pow", "floor", "ceil", "sin", "cos", "tan", "rose", "stable", "past", "rose_gclk", "stable_gclk", "future_gclk", "falling_gclk", "changing_gclk", "unpacked_dimensions", "left", "low", "increment", "assertoff", "assertcontrol", "assertpassoff", "assertfailoff", "assertvacuousoff", "error", "info", "asyncandplane", "asyncnandplane", "asyncorplane", "asyncnorplane", "syncandplane", "syncnandplane", "syncorplane", "syncnorplane", "system"));

    public Check_R_1150(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.checkNames(this.fOVMProject.getAllFunctions(), "Function");
        this.checkNames(this.fOVMProject.getAllTasks(), "Task");
    }

    private void checkNames(NullProtectedList<RfNamedElement> elements, String type) {
        for (RfNamedElement element : elements) {
            RfFunction function;
            this.notifyCheckAlive();
            if (!(element instanceof RfFunction) || (function = (RfFunction)element).getDeclaration() != null && this.checkPreWaivers(function.getDeclaration().getParserPath())) continue;
            String name = function.getName();
            if (function.isPredefined() || !this.systemFunctions.contains(name)) continue;
            this.addHit(function, String.valueOf(type) + " '" + name + "' is named after a system function!");
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

