/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.23")
@CheckID(value="R.1151")
@CheckName(value="R.1151")
@CheckLabel(labels={RuleLabel.FIELD, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use the policy field when overriding the do_record, do_compare, and do_pack methods")
@CheckDescription(value="When overriding the do_print, do_record, do_compare, and do_pack methods methods, do not make use of the \nrecorder, comparer and packer policy object fields to those methods within the body of the overridden method.\n\nThe policy object arguments do have their uses, but they are not necessary in most cases and they add complexity to the code.\n\nCheck supports pre-waiving.")
public class Check_R_1151
extends OVMComplianceCheck {
    Map<String, String> methodNames = new HashMap<String, String>();

    public Check_R_1151(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.methodNames.put("do_record", "recorder");
        this.methodNames.put("do_compare", "comparer");
        this.methodNames.put("do_pack", "packer");
    }

    @Override
    public void performCheckImpl() {
        String XVM_OBJECT_NAME = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object");
        RfClass xvmObject = this.fOVMProject.getRfProject().getClass(XVM_OBJECT_NAME, true);
        if (xvmObject == null) {
            return;
        }
        Set<RfClass> allObjects = this.fOVMProject.getAllXVMSubClasses(xvmObject);
        if (allObjects.isEmpty()) {
            return;
        }
        for (RfClass object : allObjects) {
            this.checkClass(object);
        }
    }

    private void checkClass(RfClass clazz) {
        this.notifyCheckAlive();
        RfFileDef file = clazz.getFile();
        if (file == null) {
            return;
        }
        if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) {
            return;
        }
        this.checkMethods(clazz.getLocalMembers(RfFunction.class));
    }

    private void checkMethods(Collection<RfFunction> methods) {
        if (methods == null || methods.isEmpty()) {
            return;
        }
        for (RfFunction method : methods) {
            String name;
            if (method == null || !this.methodNames.containsKey(name = method.getName())) continue;
            LocalHidOperatorVisitor hidOperatorVisitor = new LocalHidOperatorVisitor();
            hidOperatorVisitor.setMethodName(name);
            method.visitHidObject(null, hidOperatorVisitor);
        }
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        private final String XVM_PKG;
        private static final String POLICY = "policy";
        private String currentMethodName;
        ParserPath parserPath;

        public LocalHidOperatorVisitor() {
            this.XVM_PKG = String.valueOf(OVMUtils.prependLibraryPrefixTo(Check_R_1151.this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(Check_R_1151.this.fOVMProject.getLibraryKind(), "_");
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(RfHidOperator hidObject) {
            if (hidObject == null) {
                return true;
            }
            ArrayList<RfHid> hids = new ArrayList<RfHid>();
            this.checkHidCandidate(hids, hidObject.getLHValue());
            ListContainer rhValues = hidObject.getRHValues();
            if (rhValues != null) {
                for (IHidObject rhVal : hidObject.getRHValues()) {
                    this.checkHidCandidate(hids, rhVal);
                }
            }
            for (RfHid hid : hids) {
                String fullName = hid.getElement().getFullNameLabel();
                String argumentName = Check_R_1151.this.methodNames.get(this.currentMethodName);
                if (!fullName.equals(String.valueOf(this.XVM_PKG) + argumentName + "." + POLICY)) continue;
                Check_R_1151.this.addHit(this.parserPath, hid, "Policy field of argument '" + argumentName + "' in overriden method '" + this.currentMethodName + "' is used inside the method body!");
                break;
            }
            return true;
        }

        private void checkHidCandidate(List<RfHid> hids, IHidObject hidObject) {
            if (!(hidObject instanceof RfHid)) {
                return;
            }
            RfHid hid = (RfHid)hidObject;
            IRfNamedElement elem = hid.getElement();
            if (!(elem instanceof RfField)) {
                return;
            }
            String name = elem.getName();
            if (name == null || !name.equals(POLICY)) {
                return;
            }
            hids.add(hid);
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public void setMethodName(String name) {
            this.currentMethodName = name;
        }
    }
}

