/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.ImportInfo;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfResultImplicitVariable;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="22.1.22")
@CheckID(value="R.1152")
@CheckName(value="R.1152")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PACKAGE, RuleLabel.IMPORT})
@CheckTitle(value="Banned packages")
@CheckDescription(value="This check flags the imports of the <packageNames> packages.\n\nCheck supports pre-waiving.")
public class Check_R_1152
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of package names.", name="packageNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pPackageNames;
    @CheckParameter(defaultValue="false", description="When true, usages of types declared in the banned packages are also checked.", name="checkPackageUsages", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckPackageUsages;

    public Check_R_1152(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pPackageNames.isEmpty()) {
            return;
        }
        this.fOVMProject.getRfProject().accept(namedElement -> {
            if (namedElement.getDeclaration() != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(namedElement.getDeclaration().getParserPath(), this)) {
                return true;
            }
            NullProtectedList<ImportInfo> packageImports = namedElement.getAllImportDeclarations();
            if (packageImports == null || packageImports.isEmpty()) {
                return true;
            }
            this.notifyCheckAlive();
            for (ImportInfo packageImport : packageImports) {
                IRfPackageElement importedPackage = packageImport.getPackage();
                if (!this.pPackageNames.contains(importedPackage.getName())) continue;
                this.addHit(packageImport.getParserPath(), packageImport.getLine(), "Illegal package import for '" + importedPackage.getName() + "'!", null);
            }
            return true;
        });
        if (!this.pCheckPackageUsages) {
            return;
        }
        LocalNamedElementVisitor typeVisitor = new LocalNamedElementVisitor();
        this.fOVMProject.getRfProject().accept(null, typeVisitor);
        HidVisitor fieldsVisitor = new HidVisitor();
        this.fOVMProject.getRfProject().visitHidObject(null, fieldsVisitor);
    }

    private boolean checkPreWaivers(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }

    private boolean checkPreWaivers(RfDefElement defElement) {
        if (defElement == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(defElement.getParserPath(), this);
    }

    private class HidVisitor
    extends RfHidVisitor {
        private HidVisitor() {
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfNamedElement)) {
                return true;
            }
            RfNamedElement namedElement = (RfNamedElement)element;
            if (Check_R_1152.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_R_1152.this.notifyCheckAlive();
            RfPackage elementPackage = namedElement.getEnclosingPackage();
            if (elementPackage == null || !Check_R_1152.this.pPackageNames.contains(elementPackage.getName())) {
                return true;
            }
            String elementType = "type";
            if (namedElement instanceof RfField) {
                elementType = "field";
            } else if (namedElement instanceof RfFunction) {
                elementType = "method";
            }
            Check_R_1152.this.addHit(this.parserPath, hid, "Illegal usage of '" + LintUtils.getNamedElementFullName(namedElement) + "' " + elementType + " from banned package '" + elementPackage.getName() + "'!");
            return true;
        }
    }

    class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        LocalNamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement namedElement) {
            RfPackage elementPackage;
            if (Check_R_1152.this.checkPreWaivers(namedElement.getDeclaration())) {
                return true;
            }
            if (namedElement instanceof RfPredefinedFunction || namedElement instanceof RfPredefinedField || namedElement instanceof RfResultImplicitVariable) {
                return true;
            }
            Check_R_1152.this.notifyCheckAlive();
            RfPackage enclosingPackage = namedElement.getEnclosingPackage();
            if (enclosingPackage != null && Check_R_1152.this.pPackageNames.contains(enclosingPackage.getName())) {
                return true;
            }
            if (namedElement instanceof RfClass) {
                RfClass parentClass;
                RfClass classs = (RfClass)namedElement;
                HashSet<RfClass> parents = new HashSet<RfClass>();
                List<RfClass> parentInterfaces = classs.getParentInterfaces();
                if (parentInterfaces != null) {
                    parents.addAll(parentInterfaces);
                }
                if ((parentClass = classs.getParent()) != null) {
                    parents.add(parentClass);
                }
                for (RfClass parent : parents) {
                    RfPackage parentPackage = parent.getEnclosingPackage();
                    if (parentPackage == null || !Check_R_1152.this.pPackageNames.contains(parentPackage.getName())) continue;
                    Check_R_1152.this.addHit(namedElement, "Illegal usage of '" + LintUtils.getNamedElementFullName(parent) + "' class from banned package '" + parentPackage.getName() + "'!");
                }
                return true;
            }
            if (!(namedElement instanceof IRfAssociatedTypeElement)) {
                return true;
            }
            RfNamedElement assocType = LintUtils.getAssociatedFinalType((IRfAssociatedTypeElement)namedElement);
            if (assocType == null) {
                return true;
            }
            if (assocType instanceof RfSpecializedClass) {
                RfSpecializedClass specializedClass = (RfSpecializedClass)assocType;
                for (IELParamValue parameter : specializedClass.getLocalElabConstantValues().values()) {
                    RfPackage parameterScope;
                    IRfNamedElement parameterElement = parameter.getNamedElement();
                    if (!(parameterElement instanceof RfNamedElement) || (parameterScope = ((RfNamedElement)parameterElement).getEnclosingPackage()) == null || !Check_R_1152.this.pPackageNames.contains(parameterScope.getName())) continue;
                    Check_R_1152.this.addHit(namedElement, "Illegal usage of '" + LintUtils.getNamedElementFullName(namedElement) + "' type from banned package '" + parameterScope.getName() + "'!");
                }
            }
            if ((elementPackage = assocType.getEnclosingPackage()) == null || !Check_R_1152.this.pPackageNames.contains(elementPackage.getName())) {
                return true;
            }
            String typeName = LintUtils.getNamedElementFullName(assocType);
            if (assocType instanceof RfStruct) {
                typeName = ((RfStruct)assocType).getAliasName();
            }
            Check_R_1152.this.addHit(namedElement, "Illegal usage of '" + typeName + "' type from banned package '" + elementPackage.getName() + "'!");
            return true;
        }
    }
}

