/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.regex.Pattern;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="22.1.22")
@CheckID(value="R.1153")
@CheckName(value="R.1153")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ENUM})
@CheckTitle(value="The zero value enum should match a specified pattern")
@CheckDescription(value="When declaring a field of enum type without a value, it will be assigned with 0 by default. This may lead to unexpected issues if the zero value enum is an actual enum value.\nIt is recommended that all enums should have a dedicated zero value.\n\nExample if <zeroValuePattern> is \"X_UNDEFINED\"\ntypedef enum {X_UNDEFINED, RED, GREEN, BLUE} my_enum1; // allowed\ntypedef enum {RED, GREEN, BLUE} my_enum2; // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1153
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="The zero value enum name pattern.", name="zeroValuePattern", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.REGEX)
    private Pattern pZeroValuePattern;

    public Check_R_1153(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfStruct> allStructsUnionsEnums = this.fOVMProject.getRfProject().getAllStructsUnionsEnums();
        for (RfStruct enumStruct : allStructsUnionsEnums) {
            if (!enumStruct.isEnum() || enumStruct.getDeclaration() == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(enumStruct.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<RfField> allEnumElems = enumStruct.getEnumElementsWithPrefix("", 2, 1);
            for (RfField enumElem : allEnumElems) {
                String name;
                int initialValue;
                String value = enumElem.getInitialValue(true);
                if (value == null || !DVTStringUtil.isNumber((String)value)) continue;
                try {
                    initialValue = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                if (initialValue != 0 || this.pZeroValuePattern.matcher(name = enumElem.getName()).matches()) continue;
                this.addHit(enumStruct, "The default zero value of '" + enumStruct.getAliasName() + "' enum does not match the specified pattern!");
            }
        }
    }
}

