/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="22.1.22")
@CheckID(value="R.1154")
@CheckName(value="R.1154")
@CheckLabel(labels={RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.CODE_COMPLEXITY})
@CheckTitle(value="Limit number of method arguments")
@CheckDescription(value="Methods should be used for a single functionality. Creating a method with too many arguments might signal that it may be too complex.\n\nCheck supports pre-waiving.")
public class Check_R_1154
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="3", description="The maximum number of arguments a method should have.", name="nofArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pNofArguments;

    public Check_R_1154(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> allMethods = new NullProtectedList<RfNamedElement>();
        allMethods.addAll(this.fOVMProject.getAllFunctions());
        allMethods.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement element : allMethods) {
            int nofParams;
            if (!(element instanceof RfFunction)) continue;
            RfFunction function = (RfFunction)element;
            this.notifyCheckAlive();
            RfDefElement declaration = function.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            String methodType = "Function";
            if (function.isTask()) {
                methodType = "Task";
            }
            if ((nofParams = function.getArguments().size()) <= this.pNofArguments) continue;
            this.addHit(function, String.valueOf(methodType) + " '" + LintUtils.getNamedElementFullName(function) + "' has too many parameters!");
        }
    }
}

