/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="22.1.22")
@CheckID(value="R.1155")
@CheckName(value="R.1155")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.STRUCT})
@CheckTitle(value="Do not declare structs")
@CheckDescription(value="This check verifies there are no structs declared in the project.\nIt is encouraged the usage of classes instead of structs.\n\nCheck supports pre-waiving.")
public class Check_R_1155
extends OVMComplianceCheck {
    public Check_R_1155(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfStruct> allStructsUnionsEnums = this.fOVMProject.getRfProject().getAllStructsUnionsEnums();
        for (RfStruct struct : allStructsUnionsEnums) {
            if (!struct.isStruct() || struct.getDeclaration() == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(struct.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            String name = struct.getAliasName();
            if (name != null) {
                this.addHit(struct, "Illegal '" + name + "' struct declaration!");
                continue;
            }
            this.addHit(struct, "Illegal anonymous struct declaration!");
        }
    }
}

