/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="22.1.22")
@CheckID(value="R.1156")
@CheckName(value="R.1156")
@CheckLabel(labels={RuleLabel.PROCEDURAL_STATEMENT, RuleLabel.METHOD, RuleLabel.CODE_COMPLEXITY})
@CheckTitle(value="Limit the nesting of procedural blocks in methods")
@CheckDescription(value="This rule checks that the nesting level of procedural blocks in functions and tasks is not higher than <nestingLevel>. \nIt's recommended to refactor the code in another method in order to reduce the complexity.\n\nExample if nestingLevel = 2:\nif (a == 0) begin\n  if (b == 1) begin\n    if (c == 2) begin  // not allowed\n      $display(string);\n    end\n  end\nend\n\nCheck supports pre-waiving.")
public class Check_R_1156
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="3", description="The highest nesting level a method should have.", name="nestingLevel", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pNestingLevel;
    @CheckParameter(defaultValue="false", description="When true, forks don't increase the nesting level.", name="skipCountingForks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipCountingForks;
    @CheckParameter(defaultValue="false", description="When true, begin end blocks from forks don't increase the nesting level.", name="skipCountingBeginEndBlocksInsideForks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipCountingBeginEndBlocksInsideForks;

    public Check_R_1156(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> allMethods = new NullProtectedList<RfNamedElement>();
        allMethods.addAll(this.fOVMProject.getAllFunctions());
        allMethods.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement element : allMethods) {
            if (!(element instanceof RfFunction)) continue;
            RfFunction function = (RfFunction)element;
            this.notifyCheckAlive();
            RfDefElement declaration = function.getDeclaration();
            if (declaration == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            this.checkBlocks(function.getLocalMembers(RfActionBlock.class), LintUtils.getNamedElementFullName(function), 0, false);
        }
    }

    private void checkBlocks(Collection<RfActionBlock> blocks, String functionName, int nestingLevel, boolean skipNextBlock) {
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        ++nestingLevel;
        for (RfActionBlock block : blocks) {
            boolean skipBlock;
            List<RfActionBlock> loopBlocks;
            RfDefElement declaration = block.getDeclaration();
            if (declaration != null && declaration.getReparseInfo() != null) continue;
            if ((block.isCase() || block.isForOrForeach()) && (loopBlocks = this.getNestedActionBlocks(block)) != null) {
                this.checkBlocks(loopBlocks, functionName, nestingLevel - 1, false);
                continue;
            }
            boolean blockIsFork = block.hasForkJoin();
            boolean bl = skipBlock = this.pSkipCountingForks && blockIsFork || this.pSkipCountingBeginEndBlocksInsideForks && skipNextBlock && block.isSimpleBeginEnd();
            if (skipBlock ? nestingLevel - 1 > this.pNestingLevel : nestingLevel > this.pNestingLevel) {
                this.addHit(block, "Maximum nesting level exceeded in '" + functionName + "'!");
                continue;
            }
            this.checkBlocks(block.getLocalMembers(RfActionBlock.class), functionName, skipBlock ? nestingLevel - 1 : nestingLevel, blockIsFork);
        }
    }

    private List<RfActionBlock> getNestedActionBlocks(RfActionBlock block) {
        List<RfActionBlock> blocks = block.getLocalMembers(RfActionBlock.class);
        if (blocks == null || blocks.isEmpty()) {
            return null;
        }
        if (block.isForOrForeach()) {
            RfActionBlock beginEndBlock;
            if (blocks.size() == 1 && (beginEndBlock = blocks.get(0)) != null && beginEndBlock.isSimpleBeginEnd()) {
                return blocks;
            }
            return null;
        }
        return blocks;
    }
}

