/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;

@CheckVersion(value="22.1.23")
@CheckID(value="R.1157")
@CheckName(value="R.1157")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.METHOD, RuleLabel.EXTERN, RuleLabel.VERIFICATION})
@CheckTitle(value="Delimiter for extern method implementations")
@CheckDescription(value="This rule enforces the usage of a specific delimiter between implementations of extern methods.\nConsecutive extern implementations must be separated by a string that contains the <delimiterString>.\n\nCheck supports pre-waiving.")
public class Check_R_1157
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="\n", description="The delimiter between implementations.", name="delimiterString", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.STRING)
    private String pDelimiterString;

    public Check_R_1157(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        ArrayList functions = new ArrayList();
        IRfNamedElementVisitor visitor = namedElement -> {
            if (!(namedElement instanceof RfFunction)) {
                return true;
            }
            this.notifyCheckAlive();
            if (((RfFunction)namedElement).isDPI() || !namedElement.isExtern()) {
                return true;
            }
            functions.add((RfFunction)namedElement);
            return true;
        };
        this.fOVMProject.getRfProject().accept(visitor);
        if (functions.isEmpty()) {
            return;
        }
        HashMap<RfFileDef, ArrayList<RfDefElement>> extFuncByFile = new HashMap<RfFileDef, ArrayList<RfDefElement>>();
        for (RfFunction rfFunction : functions) {
            RfDefElement implementation = rfFunction.getImplementation();
            if (implementation == null) continue;
            ParserPath parserPath = implementation.getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this)) continue;
            this.notifyCheckAlive();
            RfFileDef file = this.fOVMProject.getRfProject().getFile(parserPath);
            if (implementation.getReparseInfo() != null) continue;
            ArrayList<RfDefElement> funcInFile = (ArrayList<RfDefElement>)extFuncByFile.get(file);
            if (funcInFile == null) {
                funcInFile = new ArrayList<RfDefElement>();
                funcInFile.add(implementation);
                extFuncByFile.put(file, funcInFile);
                continue;
            }
            funcInFile.add(implementation);
        }
        for (Map.Entry entry : extFuncByFile.entrySet()) {
            RfFileDef file = (RfFileDef)entry.getKey();
            List implementations = (List)entry.getValue();
            ArrayList<RfDefElement> fileElements = new ArrayList<RfDefElement>(file.getChildren());
            RfDefElement prev = null;
            RfDefElement current = (RfDefElement)fileElements.get(0);
            try {
                Throwable throwable = null;
                Object var12_16 = null;
                try (BufferedReader br = new BufferedReader(new FileReader(file.getParserPath().getCanonicalPath()));){
                    int lastReadLine = 0;
                    String line = null;
                    int i = 1;
                    while (i < fileElements.size()) {
                        prev = current;
                        current = (RfDefElement)fileElements.get(i);
                        if (prev.getReparseInfo() == null && current.getReparseInfo() == null && prev instanceof RfFunctionDef && current instanceof RfFunctionDef) {
                            this.notifyCheckAlive();
                            if (implementations.contains(prev) && implementations.contains(current)) {
                                int startLine = prev.getEndLine();
                                int finishLine = current.getStartLine();
                                while (startLine > lastReadLine) {
                                    line = br.readLine();
                                    ++lastReadLine;
                                }
                                StringBuilder result = new StringBuilder();
                                int j = startLine + 1;
                                while (j < finishLine) {
                                    line = br.readLine();
                                    ++lastReadLine;
                                    result.append(line).append(DVTStringUtil.LINE_SEPARATOR);
                                    ++j;
                                }
                                if (!result.toString().contains(this.pDelimiterString)) {
                                    this.addHit(prev.getParserPath(), startLine + 1, "External methods '" + prev.getName() + "' and '" + current.getName() + "' are not separated by the default delimiter!", null);
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.fOVMProject.notifyCheckException(this, e);
            }
        }
    }
}

