/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

@CheckVersion(value="22.1.22")
@CheckID(value="R.1158")
@CheckName(value="R.1158")
@CheckLabel(labels={RuleLabel.GLOBAL, RuleLabel.PARAMETER})
@CheckTitle(value="Do not declare parameters in global scope")
@CheckDescription(value="This check verifies there are no parameters declared in global scope.\nParameters should be declared in design elements or packages to prevent namespace collisions.\n\nCheck supports pre-waiving.")
public class Check_R_1158
extends OVMComplianceCheck {
    public Check_R_1158(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        Collection<RfLibrary> libraries = rfProject.getAllLibraries();
        if (libraries != null) {
            for (RfLibrary library : libraries) {
                this.checkNamedElement(library.getParametersWithPrefix("", 384, 2, 1));
            }
        }
    }

    private void checkNamedElement(Collection<? extends RfNamedElement> outsideElements) {
        if (outsideElements == null || outsideElements.isEmpty()) {
            return;
        }
        for (RfNamedElement rfNamedElement : outsideElements) {
            if (this.checkPreWaivers(rfNamedElement.getFile()) || this.fOVMProject.isOVMElement(rfNamedElement)) continue;
            this.notifyCheckAlive();
            if (!(rfNamedElement instanceof RfField)) continue;
            this.addHit(rfNamedElement, String.valueOf(DVTStringUtil.capitalizeFirstLetter((String)LintUtils.getElementKind(rfNamedElement))) + " '" + LintUtils.getNamedElementFullName(rfNamedElement) + "' declared in global scope!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

