/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractIndentationCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="22.1.23")
@CheckID(value="R.1159")
@CheckName(value="R.1159")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.INDENTATION})
@CheckTitle(value="Named elements indentation")
@CheckDescription(value="This rule checks the indentation inside named elements.\nThe indentation of a line must be increased by exactly <numberOfWhitespaces> compared to the indentation of the enclosing block.\n\nExamples for numberOfWhitespaces = 2:\nclass test\n  int x;// allowed\nendclass\n\nclass test\n   int x;// not allowed\nendclass\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="skipSectionsWithFormatterDisabled", isVisible=true)
public class Check_R_1159
extends AbstractIndentationCheck {
    String[] namedElementsStrings = new String[]{"class", "interface", "module", "package", "program", "checker", "config", "primitive", "struct", "union", "enum", "function", "task", "clocking", "sequence", "covergroup", "constraint", "property"};

    public Check_R_1159(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean isBlockStart(LiteralToken literalToken, ParserPath path) {
        String token;
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        Object object = this.operatorsStrings;
        int n = this.operatorsStrings.length;
        int n2 = 0;
        while (n2 < n) {
            token = object[n2];
            if (text.equals(token) || text.startsWith(String.valueOf(token) + "(")) {
                return true;
            }
            ++n2;
        }
        object = this.alwaysStrings;
        n = this.alwaysStrings.length;
        n2 = 0;
        while (n2 < n) {
            token = object[n2];
            if (text.equals(token) || text.startsWith(String.valueOf(token) + "@")) {
                return true;
            }
            ++n2;
        }
        object = this.namedElementsStrings;
        n = this.namedElementsStrings.length;
        n2 = 0;
        while (n2 < n) {
            token = object[n2];
            if (text.equals(token) || text.endsWith(token)) {
                return true;
            }
            ++n2;
        }
        if (this.pIndentInsideConditionalCompilerDirectives) {
            LiteralToken nextToken = this.getWSParser().getNextToken(literalToken, path);
            String tokenAndPrevTokenString = literalToken.toString();
            if (nextToken != null) {
                tokenAndPrevTokenString = String.valueOf(tokenAndPrevTokenString) + nextToken.toString();
            }
            for (String token2 : this.openCompilerDirectives) {
                if (!text.equals(token2) && !tokenAndPrevTokenString.equals(token2) && !text.endsWith(token2) && !tokenAndPrevTokenString.endsWith(token2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isConditionStart(LiteralToken literalToken, ParserPath path) {
        return false;
    }

    @Override
    protected boolean reachedConditionEnd(LiteralToken currentToken, LiteralToken conditionStartToken, int paranthesesBalance) {
        return false;
    }

    private boolean isEndPlusSomething(LiteralToken literalToken) {
        if (literalToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
            return false;
        }
        String text = literalToken.toString();
        return !text.equals("end") && text.startsWith("end");
    }

    @Override
    protected boolean checkOtherEndBlocks(String token, LiteralToken literalToken) {
        return token.startsWith("join") && literalToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE || this.isEndPlusSomething(literalToken);
    }

    @Override
    protected boolean nextOffsetCondition(int offsetIndex, List<AbstractIndentationCheck.Offset> fileBlockOffsets, LiteralToken literalToken) {
        return offsetIndex + 1 < fileBlockOffsets.size() && (literalToken.getOffsetFile() > fileBlockOffsets.get((int)(offsetIndex + 1)).elementOffset && fileBlockOffsets.get((int)(offsetIndex + 1)).isStart || literalToken.getOffsetFile() >= fileBlockOffsets.get((int)(offsetIndex + 1)).elementOffset && !fileBlockOffsets.get((int)(offsetIndex + 1)).isStart);
    }

    @Override
    protected void populateElementsArray(List<RfNamedElement> namedElements) {
        super.populateElementsArray(namedElements);
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllClasses()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllInterfaces()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllModules()));
        namedElements.addAll(this.fOVMProject.getRfProject().getAllPackages(true));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllPrograms()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllCheckers()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllConfigurations()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllPrimitives()));
        namedElements.addAll(this.fOVMProject.getRfProject().getAllStructsUnionsEnums());
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllFunctionsAndTasks()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllClockingBlocks()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllSequences()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllCovergroups()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllConstraints()));
        namedElements.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllProperties()));
    }

    @Override
    protected boolean startFromZero() {
        return true;
    }

    @Override
    protected int otherEndBlocksindentation(int currentBlockIndentation) {
        return currentBlockIndentation;
    }

    @Override
    protected int adjustEndForActionBlock(int end, RfActionBlock actionBlock) {
        if (actionBlock.isIf()) {
            ++end;
        }
        return end;
    }
}

