/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="22.1.24")
@CheckID(value="R.1161")
@CheckName(value="R.1161")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.ALWAYS, RuleLabel.DESIGN})
@CheckTitle(value="Do not use always blocks")
@CheckDescription(value="This rule flags the usage of always blocks. It is recommended to use instead the always_ff or always_comb blocks, so the purpose of the block is clearer.\n\nCheck supports pre-waiving.")
public class Check_R_1161
extends OVMComplianceCheck {
    public Check_R_1161(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlocks = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock actionBlock : actionBlocks) {
            RfFileDef file = actionBlock.getFile();
            if (file == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            if (!actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS)) continue;
            this.addHit(actionBlock, "Always block used!");
        }
    }
}

