/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.25")
@CheckID(value="R.1162")
@CheckName(value="R.1162")
@CheckLabel(labels={RuleLabel.OPERATOR, RuleLabel.ASSIGNMENT, RuleLabel.CONDITIONAL, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use assignments as operands of ternary conditional operator")
@CheckDescription(value="This rule flags the usage of assignments as operands for ternary operators, as they always return 'true'.\n\nExample:\n\nint a,b;\nb = (a==3) ? 1 : 2 ; // allowed\nb = (a=3) ? 1 : 2 ; // not allowed\nb = a ? (a=3) : 2 ; // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1162
extends OVMComplianceCheck {
    public Check_R_1162(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (!(hidOperator instanceof RfHidOperator)) {
                    return true;
                }
                Check_R_1162.this.notifyCheckAlive();
                if (!hidOperator.isConditionalTernary()) {
                    return true;
                }
                if (Check_R_1162.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Set operators = HidUtils.flattenToOperators((IHidOperator)hidOperator);
                for (IHidOperator op : operators) {
                    if (!(op instanceof RfHidOperator) || !op.isAssignment()) continue;
                    Check_R_1162.this.addHit(this.parserPath, (HidOccurrence)((RfHidOperator)op).getOccurrence(), "Assignment '" + HidUtils.toNiceString((IHidObject)op) + "' is used as operand for ternary operator!");
                }
                return true;
            }
        });
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

