/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="22.1.25")
@CheckID(value="R.1163")
@CheckName(value="R.1163")
@CheckLabel(labels={RuleLabel.DEAD_CODE, RuleLabel.MODULE})
@CheckTitle(value="Unused module")
@CheckDescription(value="This check flags unused modules. Unused modules clutter the design and should be removed.\nImplementation Notes: This rule flags uninstantiated modules based on the elaborated design hierarchy.\n\nCheck supports pre-waiving.")
public class Check_R_1163
extends OVMComplianceCheck {
    public Check_R_1163(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final HashSet usedModules = new HashSet();
        RfHidVisitor hidVisitor = new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (Check_R_1163.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                IRfNamedElement hidNamedElement = hid.getElement();
                Check_R_1163.this.notifyCheckAlive();
                if (hidNamedElement instanceof RfModule) {
                    usedModules.add((RfNamedElement)hidNamedElement);
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), hidVisitor);
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.fOVMProject.getProject());
        if (memory == null) {
            return;
        }
        for (RfNamedElement module : this.fOVMProject.getAllModules()) {
            boolean isInstantiated;
            if (usedModules.contains(module) || this.fOVMProject.getProjectWaivers().pathIsPrewaived(module.getDeclaration().getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List instances = memory.getInstancesFor((IRfNamedElement)module, false, 1);
            boolean bl = isInstantiated = !instances.isEmpty();
            if (isInstantiated) continue;
            this.addHit(module, "Module '" + LintUtils.getNamedElementFullName(module) + "' is not used!");
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

