/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELSpecializationWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractBoundsCheck;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="22.1.27")
@CheckID(value="R.1164")
@CheckName(value="R.1164")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.SELECT, RuleLabel.FUNCTIONAL, RuleLabel.SELECT})
@CheckTitle(value="Out of bounds range of index variable in bit select")
@CheckDescription(value="This check flags bit selects that could be out of bounds due to the size of the select variable.\nIf the bit select address is out of bounds the returned value will be X for 4-state variables and 0 for 2-state variables. This can lead to unexpected behaviour that is hard to debug.\n\nImplementation Notes:\nFor parameterized size dimensions, modules must be elaborated in order to find the value of the parameter.\nIf a module is not elaborated the check will not fail for any accesses of parameterized size dimensions inside the module, but will still fail for accesses of non-parameterized dimensions.\n\nExamples:\nlogic [7:0] var;\nlogic [4:0] select_var1\nlogic [1:0] select_var2\n\nvar[select_var1] //not allowed\nvar[select_var2] //allowed\n\nCheck supports pre-waiving.")
public class Check_R_1164
extends AbstractBoundsCheck {
    public Check_R_1164(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected void checkBounds(RfHid hid, IRfNamedElement scope, List<IHidObject> selects, IRfNamedElement arrayElement, ELManager elManager, ELParamValuesHidEvaluator emptyEvaluator, Map<IRfNamedElement, Map<ELSpecializationWrapper, ELSpecializationWrapper>> specsPerElement, String[] generateBlockPaths, ParserPath parserPath) {
        Map<ELSpecializationWrapper, ELSpecializationWrapper> specializationWrappers;
        if (!(arrayElement instanceof RfField)) {
            return;
        }
        IHidEvaluationGuardian guardianForSize = ELUtils.getEvalGuardian((ELConstants.EvalExceptionZone)ELConstants.EvalExceptionZone.RANGE, (IRfNamedElement)arrayElement, null, (boolean)true, (ELManager)elManager);
        guardianForSize.updateElements(arrayElement, scope);
        IRfScopeElement enclosingScope = arrayElement.getEnclosingScope(RfModule.class);
        Map<ELSpecializationWrapper, ELSpecializationWrapper> map = specializationWrappers = enclosingScope != null ? specsPerElement.get(enclosingScope) : null;
        if (specializationWrappers != null && !specializationWrappers.isEmpty()) {
            for (ELSpecializationWrapper wrapper : specializationWrappers.values()) {
                IHidEvaluator specializationEvaluator = wrapper.getHidEvaluator(elManager);
                if (!(specializationEvaluator instanceof ELParamValuesHidEvaluator)) continue;
                String pathsText = wrapper.getPathsText();
                if (generateBlockPaths != null) {
                    boolean foundCorrespondingGenerateBlockPath = false;
                    String[] stringArray = generateBlockPaths;
                    int n = generateBlockPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String generateBlockPath = stringArray[n2];
                        if (generateBlockPath.startsWith(pathsText)) {
                            foundCorrespondingGenerateBlockPath = true;
                        }
                        ++n2;
                    }
                    if (!foundCorrespondingGenerateBlockPath) continue;
                }
                this.findAndCheckDimensions(hid, selects, arrayElement, elManager, guardianForSize, parserPath, (ELParamValuesHidEvaluator)specializationEvaluator, pathsText, scope);
            }
        } else {
            this.findAndCheckDimensions(hid, selects, arrayElement, elManager, guardianForSize, parserPath, emptyEvaluator, null, scope);
        }
    }

    private void findAndCheckDimensions(RfHid hid, List<IHidObject> selects, IRfNamedElement arrayElement, ELManager elManager, IHidEvaluationGuardian guardianForSize, ParserPath parserPath, ELParamValuesHidEvaluator evaluator, String pathsText, IRfNamedElement scope) {
        IELParamValue paramValueForSize = XUtils.getValue((ELParamValueScope)ELUtils.evaluateForSize((IHidObject)hid, (IHidEvaluator)evaluator, (IRfNamedElement)arrayElement, (IHidEvaluationGuardian)guardianForSize));
        DimensionsInfo dimensionsInfo = this.getDimensionsInfo(paramValueForSize);
        if (dimensionsInfo == null) {
            return;
        }
        this.checkPackedDimensions(hid, selects, arrayElement, elManager, evaluator, parserPath, dimensionsInfo, pathsText, scope);
    }

    private void checkPackedDimensions(RfHid hid, List<IHidObject> selects, IRfNamedElement arrayElement, ELManager elManager, ELParamValuesHidEvaluator evaluator, ParserPath parserPath, DimensionsInfo dimensions, String paths, IRfNamedElement scope) {
        int unpackedDimensionsCount;
        if (dimensions == null || dimensions.getPackedDimensions() == null) {
            return;
        }
        int[] packedDimensions = dimensions.getPackedDimensions();
        int i = unpackedDimensionsCount = dimensions.getUnpackedDimensionsCount();
        while (i < selects.size()) {
            IHidObject currentSelect = selects.get(i);
            if (!(currentSelect == null || (i - unpackedDimensionsCount) * 2 >= packedDimensions.length || this.pSkipVariablesInSelects && !this.shouldBeEvaluatedForActualValue(currentSelect) || HidUtils.isOperator((IHidObject)currentSelect) && ((HidOperator)currentSelect).isRangeOrPartSelect())) {
                int dimensionsIndex = (i - unpackedDimensionsCount) * 2;
                int smallDimension = packedDimensions[dimensionsIndex];
                int bigDimension = packedDimensions[dimensionsIndex + 1];
                this.checkDimensions(hid, arrayElement, elManager, evaluator, i, currentSelect, smallDimension, bigDimension, parserPath, paths, scope);
            }
            ++i;
        }
    }

    private DimensionsInfo getDimensionsInfo(IELParamValue paramValueForSize) {
        if (ELUtils.isUnsuccessfulEval((IELParamValue)paramValueForSize)) {
            return null;
        }
        return this.getSuccesfulEvaluationDimensionsInfo(paramValueForSize);
    }

    private DimensionsInfo getSuccesfulEvaluationDimensionsInfo(IELParamValue paramValueForSize) {
        int unpackedDimensionsCount = 0;
        DVTNumber numberForSize = paramValueForSize.getDVTNumber();
        while (!(numberForSize instanceof VlogBitVector)) {
            if (numberForSize instanceof DVTUnpackedArray) {
                numberForSize = ((DVTUnpackedArray)numberForSize).getElementType();
                ++unpackedDimensionsCount;
                continue;
            }
            return null;
        }
        VlogBitVector bitVector = (VlogBitVector)numberForSize;
        DimensionsInfo dimensionsInfo = new DimensionsInfo();
        dimensionsInfo.setUnpackedDimensionsCount(unpackedDimensionsCount);
        dimensionsInfo.setPackedDimensions(bitVector.getArrayDimensions());
        return dimensionsInfo;
    }

    private static class DimensionsInfo {
        private int unpackedDimensionsCount;
        private int[] packedDimensions;

        private DimensionsInfo() {
        }

        public int getUnpackedDimensionsCount() {
            return this.unpackedDimensionsCount;
        }

        public void setUnpackedDimensionsCount(int unpackedDimensionsCount) {
            this.unpackedDimensionsCount = unpackedDimensionsCount;
        }

        public int[] getPackedDimensions() {
            return this.packedDimensions;
        }

        public void setPackedDimensions(int[] packedDimensions) {
            this.packedDimensions = packedDimensions;
        }
    }
}

