/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;

@CheckVersion(value="22.1.28")
@CheckID(value="R.1165")
@CheckName(value="R.1165")
@CheckLabel(labels={RuleLabel.SINGULAR_DATA_TYPE, RuleLabel.DESIGN})
@CheckTitle(value="Do not use reg and wire")
@CheckDescription(value="This check flags reg and wire variable declarations. Logic is preferred instead as its purpose is more clear.\n\nCheck supports pre-waiving.")
public class Check_R_1165
extends OVMComplianceCheck {
    public Check_R_1165(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        IRfNamedElementVisitor visitor = namedElement -> {
            if (!(namedElement instanceof RfInstanceHolder)) {
                return true;
            }
            this.notifyCheckAlive();
            if (namedElement.getFile() == null || this.checkPrewaivers(namedElement.getFile().getParserPath())) {
                return true;
            }
            List<RfField> fields = ((RfInstanceHolder)namedElement).getFields();
            if (fields == null) {
                return true;
            }
            for (RfField field : fields) {
                String netType;
                DataType dataType = null;
                if (field.getAssociatedType() instanceof RfTypeAlias) {
                    IRfNamedElement fieldType = field.getAssociatedType();
                    while (((RfTypeAlias)fieldType).getAssociatedType() instanceof RfTypeAlias) {
                        fieldType = ((RfTypeAlias)fieldType).getAssociatedType();
                    }
                    if (fieldType instanceof RfAssociatedType) {
                        dataType = ((RfAssociatedType)fieldType).getDataType();
                    }
                } else {
                    dataType = field.getDataType();
                }
                if (dataType == null) continue;
                String type = dataType.getType();
                if (type != null && type.equals("reg")) {
                    this.addHit(field, "Element '" + field.getName() + "' has forbidden data type 'reg'!");
                }
                if ((netType = dataType.getNetType()) == null || !netType.equals("wire")) continue;
                this.addHit(field, "Element '" + field.getName() + "' has forbidden net type 'wire'!");
            }
            return true;
        };
        this.fOVMProject.getRfProject().accept(visitor);
    }

    public boolean checkPrewaivers(ParserPath path) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this);
    }
}

