/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="22.1.28")
@CheckID(value="R.1166")
@CheckName(value="R.1166")
@CheckLabel(labels={RuleLabel.ASSERTION})
@CheckTitle(value="Do not use checker")
@CheckDescription(value="This check flags declarations of checkers because it is not properly supported by all simulators.\n\nCheck supports pre-waiving.")
public class Check_R_1166
extends OVMComplianceCheck {
    public Check_R_1166(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement element : this.fOVMProject.getAllCheckers()) {
            if (!(element instanceof RfChecker)) continue;
            RfChecker checker = (RfChecker)element;
            RfDefElement declaration = checker.getDeclaration();
            this.notifyCheckAlive();
            if (declaration != null && this.checkPreWaivers(declaration.getParserPath())) continue;
            this.addHit(checker, "Illegal declaration of checker '" + LintUtils.getNamedElementFullName(checker) + "'!");
        }
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

