/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="22.1.28")
@CheckID(value="R.1167")
@CheckName(value="R.1167")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.FINAL, RuleLabel.DESIGN})
@CheckTitle(value="Do not use final blocks")
@CheckDescription(value="Final blocks are executed only when a simulation completes.\n\nCheck supports pre-waiving.")
public class Check_R_1167
extends OVMComplianceCheck {
    public Check_R_1167(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(this.fOVMProject.getRfProject(), new LocalNamedElementVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class LocalNamedElementVisitor
    implements IRfNamedElementVisitor {
        private LocalNamedElementVisitor() {
        }

        @Override
        public boolean visit(RfNamedElement element) {
            if (!(element instanceof RfActionBlock)) {
                return true;
            }
            RfActionBlock block = (RfActionBlock)element;
            RfDefElement declaration = block.getDeclaration();
            if (declaration != null && Check_R_1167.this.checkPreWaivers(declaration.getParserPath())) {
                return true;
            }
            Check_R_1167.this.notifyCheckAlive();
            if (!block.isFinal()) {
                return true;
            }
            Check_R_1167.this.addHit(block, "Illegal usage of final block!");
            return true;
        }
    }
}

