/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.rules.AbstractInstanceNamingCheck;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="22.1.28")
@CheckID(value="R.1168")
@CheckName(value="R.1168")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.MODULE})
@CheckTitle(value="Module instances naming pattern")
@CheckDescription(value="All module instances must match the namePattern pattern.\n\nImplementation Notes:\nModule instances inside modules are checked.\n\nExamples for namePattern='mod\\d':\nmodule my_mod;\nendmodule\n\nmodule m;\n\tmy_mod a(); // not allowed\n\tmy_mod mod1(); // allowed\nendmodule\nExamples for namePattern='$type_name_inst':\n\nmodule m;\n\tmy_mod my_inst(); // not allowed\n\tmy_mod my_mod_inst(); // allowed\nendmodule\n")
public class Check_R_1168
extends AbstractInstanceNamingCheck {
    public Check_R_1168(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean hasRightType(RfNamedElement fieldType) {
        return fieldType instanceof RfModule;
    }

    @Override
    protected void addLocalHit(RfNamedElement eachMember, String name, String memberName) {
        this.addHit(eachMember, "Illegal name for module instance '" + name + "." + memberName + "'!");
    }
}

