/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.Check_SVTB_29_1_0;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

@CheckVersion(value="22.1.28")
@CheckID(value="R.1169")
@CheckName(value="R.1169")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PREDEFINED_METHOD})
@CheckTitle(value="Banned predefined methods")
@CheckDescription(value="Calls to bannedMethods are forbidden.\n\nExamples for bannedMethods = '$display':\nmodule my_module;\n\tinitial begin\n\t\t$display(\"Display call!\"); // not allowed\n\tend\nendmodule\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="bannedMethodsPatterns", isVisible=false), @CheckParameterOverride(name="bannedMethods", description="Comma separated list of banned predefined method names.\nFor example $stop, $display, $random.")})
public class Check_R_1169
extends Check_SVTB_29_1_0 {
    public Check_R_1169(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<String> invalidMethods = new HashSet<String>();
        for (String bannedMethod : this.pBannedMethodsValue) {
            RfFunction method = this.fOVMProject.getRfProject().getFunctionWithPrefix(bannedMethod, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            if (method == null) {
                method = this.fOVMProject.getRfProject().getTaskWithPrefix(bannedMethod, 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
            }
            if (method != null && method instanceof RfPredefinedFunction) continue;
            this.signalParamError(String.valueOf(bannedMethod) + " is not a valid predefined method name!", false);
            invalidMethods.add(bannedMethod);
        }
        if (!invalidMethods.isEmpty()) {
            this.pBannedMethodsValue.removeAll(invalidMethods);
        }
        super.performCheckImpl();
    }
}

