/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTPair;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="22.1.30")
@CheckID(value="R.1170")
@CheckName(value="R.1170")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.INDENTATION, RuleLabel.PARAMETER})
@CheckTitle(value="Named parameter list indentation")
@CheckDescription(value="This check verifies that the parameter list has an indentation of <numberOfWhitespaces> relative to the module instantiation.\nThe indentation must be relative to the indentation of the line containing the opening parenthesis for the parameters list.\nThe indentation on the line with the closing parenthesis must be the same as the one on the line with the opening parenthesis.\n\nExamples for numberOfWhitespaces = 2 :\nmodule test_module_1;\n test_module #(.a(a), .b(b), .c(c)) t(); // not allowed\nendmodule\n\nmodule test_module_2;\ntest_module #( // allowed\n  .a(a),\n  .b(b),\n  .c(c)\n) t();\nendmodule\n\nCheck supports pre-waiving.")
public class Check_R_1170
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="2", description="Number of whitespaces used for indentation", name="numberOfWhitespaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected int pNumberOfWhitespaces;
    @CheckParameter(defaultValue="false", description="When true, flags the instance name if it is not on the same line with the closing paranthesis of the parameter list", name="checkInstanceNameOnSameLine", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckInstanceNameOnSameLine;
    @CheckParameter(defaultValue="false", description="When true, flags the instance name if it is not spaced from the closing paranthesis of the parameter list.", name="checkSpaceBeforeInstanceName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pCheckSpaceBeforeInstanceName;
    @CheckParameter(defaultValue="false", description="When true, we will not throw hits when a comment is placed on an empty line", name="allowCommentsOnEmptyLines", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    protected boolean pAllowCommentsOnEmptyLines;

    public Check_R_1170(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap<RfFileDef, ArrayList<RfInstance>> instanceByFile = new HashMap<RfFileDef, ArrayList<RfInstance>>();
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllModules()) {
            List<RfInstance> instantiations = rfNamedElement.getInstancesWithPrefix("", 2, 1);
            for (RfInstance instance : instantiations) {
                RfFileDef file = instance.getFile();
                if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) continue;
                ArrayList<RfInstance> instanceInFile = (ArrayList<RfInstance>)instanceByFile.get(file);
                if (instanceInFile == null) {
                    instanceInFile = new ArrayList<RfInstance>();
                    instanceInFile.add(instance);
                    instanceByFile.put(file, instanceInFile);
                    continue;
                }
                instanceInFile.add(instance);
            }
        }
        for (Map.Entry entry : instanceByFile.entrySet()) {
            RfFileDef file = (RfFileDef)entry.getKey();
            List instances = (List)entry.getValue();
            ParserPath parserPath = file.getParserPath();
            for (RfInstance instance : instances) {
                int labelLine;
                RfDefElement declaration;
                Map<String, ArgInfo> namedParams;
                this.notifyCheckAlive();
                DataType dataType = instance.getDataType();
                Map<String, ArgInfo> map = namedParams = dataType != null ? dataType.getNamedParamAssignments() : null;
                if (namedParams == null || namedParams.isEmpty()) continue;
                int endLine = instance.getEndLine();
                int startOffset = instance.getStartOffset();
                LiteralToken literalToken = this.getWSParser().getToken(startOffset, parserPath);
                while (!(literalToken == null || literalToken.getStringToken().contains("(") && literalToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE)) {
                    literalToken = this.getWSParser().getNextToken(literalToken, parserPath);
                }
                if (literalToken == null) continue;
                int currentLine = literalToken.getLineNumber();
                int openParenthesisCount = 0;
                int closedParenthesisCount = 0;
                while (literalToken != null && literalToken.getLineNumber() == currentLine) {
                    if (literalToken.getStringToken().contains(".") && literalToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                        this.addHit(parserPath, currentLine, "Parameters must not be on the same line with the opening parenthesis for the parameters list!", null);
                        break;
                    }
                    literalToken = this.getWSParser().getNextToken(literalToken, parserPath);
                }
                List<LiteralToken> tokens = this.getWSParser().getTokensOnLine(parserPath, currentLine);
                if (tokens.isEmpty()) continue;
                DVTPair<Integer, Integer> parenthesis = this.parseTokens(tokens, closedParenthesisCount, openParenthesisCount, parserPath);
                closedParenthesisCount = (Integer)parenthesis.getKey();
                openParenthesisCount = (Integer)parenthesis.getValue();
                int startIndentation = tokens.get(0).getNoSpacesBefore();
                int expectedIndentation = startIndentation + this.pNumberOfWhitespaces;
                if (tokens.get(0).getNoTabsBefore() != 0) {
                    this.addHit(parserPath, currentLine, "Tabs were used for indentation!", null);
                    continue;
                }
                if (openParenthesisCount == closedParenthesisCount && tokens.get(0).getStringToken().charAt(0) != ')') {
                    this.addHit(parserPath, currentLine, "The closing parenthesis for the parameters list must be on a new line!", null);
                }
                while (openParenthesisCount != closedParenthesisCount && currentLine <= endLine) {
                    tokens = this.getWSParser().getTokensOnLine(parserPath, ++currentLine);
                    if (tokens.isEmpty()) continue;
                    parenthesis = this.parseTokens(tokens, closedParenthesisCount, openParenthesisCount, parserPath);
                    closedParenthesisCount = (Integer)parenthesis.getKey();
                    openParenthesisCount = (Integer)parenthesis.getValue();
                    LiteralToken firstToken = tokens.get(0);
                    if (firstToken.getNoTabsBefore() != 0) {
                        this.addHit(parserPath, currentLine, "Tabs were used for indentation!", null);
                        continue;
                    }
                    int currentIndentation = firstToken.getNoSpacesBefore();
                    if (firstToken.getZone() == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || firstToken.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT && !this.pAllowCommentsOnEmptyLines) {
                        this.addHit(parserPath, currentLine, "Comments should pe placed after the parameter!", null);
                    }
                    if (openParenthesisCount == closedParenthesisCount && firstToken.getStringToken().charAt(0) == ')') {
                        if (currentIndentation != startIndentation) {
                            this.addHit(parserPath, currentLine, "Wrong indentation! You should use " + String.valueOf(startIndentation) + " whitespaces!", null);
                        }
                    } else if (openParenthesisCount == closedParenthesisCount && firstToken.getStringToken().charAt(0) != ')') {
                        this.addHit(parserPath, currentLine, "The closing parenthesis for the parameters list must be on a new line!", null);
                    } else if (currentIndentation != expectedIndentation) {
                        this.addHit(parserPath, currentLine, "Wrong indentation! You should use " + String.valueOf(expectedIndentation) + " whitespaces!", null);
                    }
                    if (this.pAllowCommentsOnEmptyLines) {
                        boolean allComments = true;
                        for (LiteralToken token : tokens) {
                            if (token.getZone() == SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || token.getZone() == SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) continue;
                            allComments = false;
                            break;
                        }
                        if (allComments) continue;
                    }
                    if (firstToken.getZone() != SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT && firstToken.getZone() != SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) continue;
                    this.addHit(parserPath, currentLine, "Comments should pe placed after the parameter!", null);
                }
                if (tokens.isEmpty()) continue;
                if (this.pCheckInstanceNameOnSameLine && openParenthesisCount == closedParenthesisCount) {
                    declaration = instance.getDeclaration();
                    if (declaration == null) continue;
                    labelLine = declaration.getLabelStartLine();
                    if (labelLine != currentLine) {
                        this.addHit(parserPath, labelLine, "The closing parenthesis for the parameters list and the instance name should be on the same line!", null);
                    }
                }
                if (!this.pCheckSpaceBeforeInstanceName || openParenthesisCount != closedParenthesisCount || (declaration = instance.getDeclaration()) == null) continue;
                labelLine = declaration.getLabelStartLine();
                int labelOffset = declaration.getLabelStartOffset();
                LiteralToken token2 = this.getWSParser().getToken(labelOffset, parserPath);
                if (token2 != null) continue;
                this.addHit(parserPath, labelLine, "There must be space between the closing paranthesis for the parameters list and the instance name!", null);
            }
        }
    }

    DVTPair<Integer, Integer> parseTokens(List<LiteralToken> tokens, int closedParenthesisCount, int openParenthesisCount, ParserPath parserPath) {
        boolean multipleParams = false;
        for (LiteralToken token : tokens) {
            if (token.getZone() != SVTBWhitespaceParser.ZoneType.CODE) continue;
            if (multipleParams) {
                this.addHit(parserPath, token.getLineNumber(), "Do not place multiple parameters on a single line!", null);
            }
            String stringToken = token.getStringToken();
            int i = 0;
            while (i < stringToken.length()) {
                char ch = stringToken.charAt(i);
                if (ch == ')') {
                    ++closedParenthesisCount;
                } else if (ch == '(') {
                    ++openParenthesisCount;
                } else if (ch == ',') {
                    multipleParams = true;
                }
                if (openParenthesisCount == closedParenthesisCount && openParenthesisCount != 0) break;
                ++i;
            }
            if (openParenthesisCount == closedParenthesisCount && openParenthesisCount != 0) break;
        }
        return new DVTPair((Object)closedParenthesisCount, (Object)openParenthesisCount);
    }
}

