/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="22.1.30")
@CheckID(value="R.1171")
@CheckName(value="R.1171")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CONDITIONAL_DIRECTIVE, RuleLabel.INCLUDE_GUARD})
@CheckTitle(value="Do not use multiple include guards")
@CheckDescription(value="This check flags multiple `ifndef file guards in the same file.\n\nNot allowed:\n`ifndef __GICA\n`define __GICA\n`ifndef GICA_1\n`define GICA_1\n...\n`endif\n`endif\n\nCheck supports pre-waiving.")
public class Check_R_1171
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String IFNDEF_STRING = "`ifndef";
    private static final String DEFINE_STRING = "`define";
    private static final String ENDIF_STRING = "`endif";

    public Check_R_1171(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<ParserPath> parserPaths = this.getOVMProject().getAllImportedFiles();
        for (ParserPath path : parserPaths) {
            LiteralToken endifToken;
            LiteralToken defineToken;
            LiteralToken ifndefToken;
            if (this.checkPreWaivers(path)) continue;
            this.notifyCheckAlive();
            Map<Integer, LiteralToken> tokens = this.getWSParser().getTokens(path);
            if (tokens == null) continue;
            LinkedList<LiteralToken> literalTokens = new LinkedList<LiteralToken>(tokens.values());
            int i = 0;
            int lastTokenIndex = literalTokens.size() - 1;
            if ((i = this.getNextCodeTokenIndex(literalTokens, i, lastTokenIndex)) > lastTokenIndex || !(ifndefToken = (LiteralToken)literalTokens.get(i)).getStringToken().equals(IFNDEF_STRING) || (i = this.getNextCodeTokenIndex(literalTokens, i + 2, lastTokenIndex)) > lastTokenIndex || !(defineToken = (LiteralToken)literalTokens.get(i)).getStringToken().equals(DEFINE_STRING) || !this.getWSParser().getNextToken(ifndefToken, path).getStringToken().equals(this.getWSParser().getNextToken(defineToken, path).getStringToken()) || (i = this.getNextCodeTokenIndex(literalTokens, i + 2, lastTokenIndex)) > lastTokenIndex || !(ifndefToken = (LiteralToken)literalTokens.get(i)).getStringToken().equals(IFNDEF_STRING) || (i = this.getNextCodeTokenIndex(literalTokens, i + 2, lastTokenIndex)) > lastTokenIndex || !(defineToken = (LiteralToken)literalTokens.get(i)).getStringToken().equals(DEFINE_STRING) || !this.getWSParser().getNextToken(ifndefToken, path).getStringToken().equals(this.getWSParser().getNextToken(defineToken, path).getStringToken())) continue;
            i = lastTokenIndex;
            if ((i = this.getPreviousCodeTokenIndex(literalTokens, i)) < 0 || !(endifToken = (LiteralToken)literalTokens.get(i)).getStringToken().equals(ENDIF_STRING) || (i = this.getPreviousCodeTokenIndex(literalTokens, i)) < 0 || !(endifToken = (LiteralToken)literalTokens.get(i)).getStringToken().equals(ENDIF_STRING)) continue;
            this.addHit(path, ifndefToken.getLineNumber(), "Multiple `ifndef file guards not allowed!", null);
        }
    }

    private int getPreviousCodeTokenIndex(List<LiteralToken> literalTokens, int index) {
        while (index >= 0) {
            LiteralToken token = literalTokens.get(index);
            if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE) break;
            --index;
        }
        return index;
    }

    private int getNextCodeTokenIndex(List<LiteralToken> literalTokens, int index, int lastTokenIndex) {
        while (index <= lastTokenIndex) {
            LiteralToken token = literalTokens.get(index);
            if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE) break;
            ++index;
        }
        return index;
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

