/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="22.1.30")
@CheckID(value="R.1172")
@CheckName(value="R.1172")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.COMMENT})
@CheckTitle(value="Separate single-line comments from the code")
@CheckDescription(value="This rule verifies that single-line comments are separated from the code by at least <nofSpaces> whitespaces.\n\nFor nofSpaces = 2:\nint a;  //allowed\nint b; //not allowed\nint c;//not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1172
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    @CheckParameter(defaultValue="2", description="The allowed minimum number of spaces between code and single-line comment identifier '//'.", name="nofSpaces", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    private int pNofSpaces;

    public Check_R_1172(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashSet<ParserPath> parserPaths = this.getOVMProject().getAllImportedFiles();
        for (ParserPath path : parserPaths) {
            if (this.checkPreWaivers(path)) continue;
            this.notifyCheckAlive();
            Map<Integer, LiteralToken> tokens = this.getWSParser().getTokens(path);
            if (tokens == null) continue;
            for (LiteralToken token : tokens.values()) {
                LiteralToken prevToken;
                if (token.getZone() != SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT || token.isFirstTokenOnLine() || !token.getStringToken().startsWith("//") || (prevToken = this.getWSParser().getPrevToken(token, path)) == null || prevToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE || token.getNoSpacesBefore() >= this.pNofSpaces) continue;
                this.addHit(path, token.getLineNumber(), "Wrong spacing before //, at the character position " + (token.getOffsetLine() + 1) + " on the line!", null);
            }
        }
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

