/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="22.1.30")
@CheckID(value="R.1173")
@CheckName(value="R.1173")
@CheckLabel(labels={RuleLabel.COMMENT, RuleLabel.STYLING, RuleLabel.CODE_COMPLEXITY})
@CheckTitle(value="Do not add multi-line comments inside of a statement")
@CheckDescription(value="Do not use multi-line comments between code in a statement. Comments like these are unnecessary and add complexity.\n\nExample:\nint a = b + /*comment*/ c; // not allowed\n// Comment\nint a = b + c; // allowed\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_R_1173
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final Pattern AT_PATTERN = Pattern.compile(".*@.*");
    private static final Pattern IF_PATTERN = Pattern.compile("if(\\(.*)?");
    private static final Pattern FOR_PATTERN = Pattern.compile("for(\\(.*)?");
    private static final Pattern WHILE_PATTERN = Pattern.compile("while(\\(.*)?");
    private static final Pattern FOREACH_PATTERN = Pattern.compile("foreach(\\(.*)?");
    private static final Pattern REPEAT_PATTERN = Pattern.compile("repeat(\\(.*)?");
    private static final Pattern FORK_PATTERN = Pattern.compile("fork");
    private static final Pattern JOIN_PATTERN = Pattern.compile("join");
    private static final Pattern JOIN_NONE_PATTERN = Pattern.compile("join_none");
    private static final Pattern JOIN_ANY_PATTERN = Pattern.compile("join_any");
    private static final Pattern BEGIN_PATTERN = Pattern.compile("begin");
    private static final Pattern ELSE_PATTERN = Pattern.compile("else");
    private static final Pattern DO_PATTERN = Pattern.compile("do");
    private static final Pattern ALWAYS_PATTERN = Pattern.compile("always");
    private static final Pattern FOREVER_PATTERN = Pattern.compile("forever");
    private static final Pattern ASSERTIONS_PATTERN = Pattern.compile("([a-zA-Z_$][a-zA-Z0-9_$]*:(assert|assume|cover|restrict))|(:?(assert|assume|cover|restrict))(\\(.*)?");
    List<Pattern> skippedStatementsPatterns = new ArrayList<Pattern>(Arrays.asList(FORK_PATTERN, JOIN_PATTERN, JOIN_NONE_PATTERN, JOIN_ANY_PATTERN, BEGIN_PATTERN, ELSE_PATTERN, DO_PATTERN, ALWAYS_PATTERN, FOREVER_PATTERN));
    List<Pattern> paranthesisStatementsPatterns = new ArrayList<Pattern>(Arrays.asList(IF_PATTERN, FOR_PATTERN, WHILE_PATTERN, FOREACH_PATTERN, REPEAT_PATTERN, ASSERTIONS_PATTERN));

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(114);
    }

    public Check_R_1173(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<ParserPath, List<SVTBIssues>> allIssues = this.fOVMProject.getSVTBIssuesWithKind(114);
        for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
            ParserPath path = entry.getKey();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this)) continue;
            this.notifyCheckAlive();
            List<SVTBIssues> issues = entry.getValue();
            block1: for (SVTBIssues currentIssue : issues) {
                LiteralToken currentToken;
                if (currentIssue.getReparseInfo() != null || (currentToken = this.getWSParser().getTokenContainingOffset(currentIssue.getOffset(), path)) == null || this.isSkipToken(currentToken)) continue;
                LiteralToken originalToken = currentToken;
                while (this.isTokenInStatement(currentToken, originalToken)) {
                    currentToken = this.getWSParser().getNextToken(currentToken, path);
                    if (currentToken == null) continue block1;
                    if (!currentToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT)) continue;
                    this.addHit(path, currentToken.getLineNumber(), "Multi-line comment used inside statement!", null);
                }
            }
        }
    }

    private boolean doesStringMatchesPatterns(String str, List<Pattern> patterns) {
        return patterns.stream().anyMatch(pattern -> pattern.matcher(str).matches());
    }

    private boolean isSkipToken(LiteralToken token) {
        return token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) && this.doesStringMatchesPatterns(token.getStringToken(), this.skippedStatementsPatterns);
    }

    private boolean isTokenInStatement(LiteralToken token, LiteralToken originalToken) {
        if (AT_PATTERN.matcher(originalToken.getStringToken()).matches()) {
            return this.isTokenInStatement(token, Arrays.asList(")", ";"));
        }
        if (this.doesStringMatchesPatterns(originalToken.getStringToken(), this.paranthesisStatementsPatterns)) {
            return this.isTokenInStatement(token, Arrays.asList(")"));
        }
        return this.isTokenInStatement(token, Arrays.asList(";"));
    }

    private boolean isTokenInStatement(LiteralToken token, List<String> subTokens) {
        if (token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.STRING) || token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT)) {
            return true;
        }
        if (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE)) {
            return false;
        }
        return !subTokens.stream().anyMatch(subToken -> token.getStringToken().contains((CharSequence)subToken));
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

