/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="22.1.32")
@CheckID(value="R.1174")
@CheckName(value="R.1174")
@CheckLabel(labels={RuleLabel.MODULE, RuleLabel.XMR, RuleLabel.DESIGN})
@CheckTitle(value="Do not use cross module references deep into the design")
@CheckDescription(value="The rule checks that no cross module references go deeper than <maxLevelCrossReferences> levels.\nA maximum level is provided in order to prevent probing into the design too deep, which hinders the reusability of modules.\n\nExamples:\nif maxLevelCrossReferences = 3\npath.to.dut.foo //NOT ALLOWED\npath.to.other_dut // ALLOWED\n`define PATH_TO_DUT path.to.dut\n`PATH_TO_DUT.foo //NOT ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1174
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="3", description="Integer value representing the maximum depth of cross module references", name="maxLevelCrossReferences", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.INTEGER)
    protected Integer maxLevelCrossReferences;

    public Check_R_1174(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<RfHid> {
        private ParserPath parserPath;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        private void addLocalHit(RfHid hid, int limit) {
            Check_R_1174.this.addHit(this.parserPath, hid, "Exceeded maximum depth limit of " + limit + " for XMR: " + HidUtils.toNiceString((IHidObject)hid) + "!");
        }

        private boolean hasMoreThanNParrents(RfHid hid, int maxDepth) {
            RfHid localHid = hid;
            int currDepth = 0;
            while (localHid != null) {
                ++currDepth;
                localHid = localHid.getParentHid();
            }
            return currDepth > maxDepth;
        }

        private boolean shouldAnalyzeXMR(RfHid hid) {
            if (hid == null) {
                return false;
            }
            if (hid.getParentAccess() == null || hid.getParentHid() == null) {
                return false;
            }
            Hid parentHid = hid.getParentHid();
            while (parentHid.getParentHid() != null) {
                parentHid = parentHid.getParentHid();
            }
            IRfNamedElement parentElement = parentHid.getElement();
            return parentElement instanceof RfInstanceHolder || parentElement instanceof RfInstance;
        }

        public boolean visit(RfHid hid) {
            if (Check_R_1174.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (hid.getAccesses() != null) {
                return true;
            }
            if (!this.shouldAnalyzeXMR(hid)) {
                return true;
            }
            if (this.hasMoreThanNParrents(hid, Check_R_1174.this.maxLevelCrossReferences)) {
                this.addLocalHit(hid, Check_R_1174.this.maxLevelCrossReferences);
            }
            return true;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }
}

