/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="22.1.31")
@CheckID(value="R.1175")
@CheckName(value="R.1175")
@CheckLabel(labels={RuleLabel.FACTORY_CREATE, RuleLabel.LOOP, RuleLabel.OBJECT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not call XVM object create() in loops")
@CheckDescription(value="This check flags object_type::type_id::create calls found in loops.\nExamples:\nfor(int i = 0; i < 10; i++) begin\n  object_type obj = object_type::type_id::create() // not allowed\nend\nobject_type obj = object_type::type_id::create() // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1175
extends OVMComplianceCheck {
    private String callFunctionName;

    public Check_R_1175(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.callFunctionName = String.valueOf(OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_pkg::")) + OVMUtils.prependLibraryPrefixTo(this.fOVMProject.getLibraryKind(), "_object_registry.create");
        RfHidVisitor callVisitor = new RfHidVisitor(){
            private IRfNamedElement scope;

            @Override
            public void setHolder(IHidHolder holder) {
                if (holder instanceof HidHolder) {
                    this.scope = ((HidHolder)holder).getScope();
                }
            }

            public boolean visit(RfHid rfHid) {
                String name = LintUtils.getFileShortName(this.parserPath.path);
                if (Check_R_1175.this.fOVMProject.isOVMFile(name)) {
                    return true;
                }
                if (Check_R_1175.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                IRfNamedElement rfNamedElement = rfHid.getElement();
                if (rfNamedElement == null || !(rfNamedElement instanceof RfFunction)) {
                    return true;
                }
                Check_R_1175.this.notifyCheckAlive();
                if (!((RfFunction)rfNamedElement).getFullName().equals(Check_R_1175.this.callFunctionName)) {
                    return true;
                }
                if (!(this.scope instanceof RfNamedElement)) {
                    return true;
                }
                RfNamedElement scopeIterator = (RfNamedElement)this.scope;
                while (scopeIterator instanceof RfActionBlock) {
                    if (scopeIterator instanceof RfActionBlock && ((RfActionBlock)scopeIterator).isLoop()) {
                        Check_R_1175.this.addHit(this.parserPath, rfHid, "Calling '" + LintUtils.getNamedElementFullName((RfNamedElement)rfNamedElement) + "' in a loop is not allowed!");
                        return true;
                    }
                    scopeIterator = scopeIterator.getEnclosingScope();
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, callVisitor);
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

