/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.XVMMacros;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="22.1.32")
@CheckID(value="R.1176")
@CheckName(value="R.1176")
@CheckLabel(labels={RuleLabel.MESSAGING, RuleLabel.MACRO, RuleLabel.REPORTING_MACRO, RuleLabel.FORMAT_SPECIFIER})
@CheckTitle(value="Do not use get_name() methods or %m with XVM report macros")
@CheckDescription(value="Do not use the XVM get_name() methods or $sformatf with a format string containing %m with XVM report macros as the report macros automatically print the full hierarchy.\n\nExamples:\n`uvm_info(get_full_name(), \"some info message\", UVM_LOW) // not allowed\n`uvm_info(\"ID\", $sformatf(\"some message %m\", obj), UVM_LOW) // not allowed\n`uvm_info(\"ID\", $sformatf(\"some message \"), UVM_LOW) // allowed\n\nCheck supports pre-waiving.")
public class Check_R_1176
extends OVMComplianceCheck {
    private static final String SFORMATF = "$sformatf";
    @CheckParameter(defaultValue="get_full_name, get_name, get_type_name", description="Comma separated list of banned methods names.", name="bannedMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    protected Set<String> pBannedMethods;
    private HashSet<String> forbiddenReportMacros = new HashSet();
    private static String PATTERN_ARGUMENT = ".*[^%]%[mM].*";

    public Check_R_1176(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        if (this.fOVMProject.getLibraryKind() == 2) {
            this.forbiddenReportMacros.addAll(XVMMacros.UVM_REPORT_MACROS);
            this.forbiddenReportMacros.add("`uvm_info_begin");
            this.forbiddenReportMacros.add("`uvm_warning_begin");
            this.forbiddenReportMacros.add("`uvm_error_begin");
            this.forbiddenReportMacros.add("`uvm_fatal_begin");
        } else {
            this.forbiddenReportMacros.addAll(XVMMacros.OVM_REPORT_MACROS);
        }
    }

    @Override
    public void performCheckImpl() {
        RfHidVisitor callVisitor = new RfHidVisitor(){
            IRfNamedElement scope;

            public void setScope(IRfNamedElement scope) {
                this.scope = scope;
            }

            public boolean visit(RfHid rfHid) {
                String name = LintUtils.getFileShortName(this.parserPath.path);
                if (Check_R_1176.this.fOVMProject.isOVMFile(name)) {
                    return true;
                }
                if (Check_R_1176.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                IRfNamedElement element = rfHid.getElement();
                if (element == null || !(element instanceof RfFunction)) {
                    return true;
                }
                Check_R_1176.this.notifyCheckAlive();
                if (!Check_R_1176.SFORMATF.equals(((RfFunction)element).getName()) && !Check_R_1176.this.pBannedMethods.contains(((RfFunction)element).getName())) {
                    return true;
                }
                HidOccurrence occurrence = rfHid.getOccurrence();
                if (occurrence == null) {
                    return true;
                }
                IReparseInfo reparseInfo = rfHid.getReparseInfo();
                if (reparseInfo == null || !(reparseInfo instanceof ReparseInfo)) {
                    return true;
                }
                ReparseInfo.ReparseElement[] reparseStack = ((ReparseInfo)reparseInfo).getReparseStack();
                if (reparseStack == null || reparseStack.length == 0) {
                    return true;
                }
                if (reparseStack[0] == null || reparseStack[0].getReparseMacroName() == null) {
                    return true;
                }
                String macroName = "`" + reparseStack[0].getReparseMacroName();
                if (!Check_R_1176.this.forbiddenReportMacros.contains(macroName)) {
                    return true;
                }
                if (((RfFunction)element).getName().equals(Check_R_1176.SFORMATF)) {
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                    if (methodCalls == null || methodCalls.isEmpty()) {
                        return true;
                    }
                    for (MethodCall methodCall : methodCalls) {
                        String nameValue;
                        Iterator iterator;
                        Map.Entry formatString;
                        Map argumentValuesMapRaw = methodCall.argumentValuesMapRaw;
                        if (argumentValuesMapRaw == null || argumentValuesMapRaw.isEmpty() || !((formatString = (iterator = argumentValuesMapRaw.entrySet().iterator()).next()).getKey() instanceof RfPredefinedField) || !((IRfFieldElement)formatString.getKey()).getName().equals("format_string") || !(formatString.getValue() instanceof RfHidImplicit) || !(nameValue = ((RfHidImplicit)formatString.getValue()).getName()).matches(PATTERN_ARGUMENT)) continue;
                        Check_R_1176.this.addHit(this.parserPath, occurrence.getLine(), "Do not use '$sformatf(\"%m\")' in the parameters of " + macroName + "!", null);
                    }
                } else {
                    Hid parentAccess = rfHid.getParentHid();
                    if (parentAccess != null && !"this".equals(parentAccess.getName())) {
                        return true;
                    }
                    RfClass enclosingClassElement = (RfClass)element.getEnclosingScope(RfClass.class);
                    RfClass enclosingClassHid = (RfClass)this.scope.getEnclosingScope(RfClass.class);
                    if (enclosingClassElement != null && Check_R_1176.this.fOVMProject.isOVMElement(enclosingClassElement) || LintUtils.isSubClassOf(enclosingClassHid, enclosingClassElement)) {
                        Check_R_1176.this.addHit(this.parserPath, occurrence.getLine(), "Do not use '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "()' in the parameters of " + macroName + "!", null);
                    }
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, callVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

