/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="22.1.32")
@CheckID(value="R.1179")
@CheckName(value="R.1179")
@CheckLabel(labels={RuleLabel.DUPLICATE_CODE, RuleLabel.COMMENT})
@CheckTitle(value="Duplicate comments")
@CheckDescription(value="Using the same comment or copy-pasting the same comment multiple times may reduce the readability of the code and might leave inaccurate descriptions.\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_R_1179
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    public Check_R_1179(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<ParserPath> files = this.fOVMProject.getAllFilesInOrder();
        if (files == null || files.isEmpty()) {
            return;
        }
        TreeSet<CommentBlock> commentBlocks = new TreeSet<CommentBlock>((o1, o2) -> this.compare((CommentBlock)o1, (CommentBlock)o2));
        for (ParserPath file : files) {
            Map<Integer, LiteralToken> tokensInFile;
            if (this.checkPrewaivers(file) || (tokensInFile = this.getWSParser().getTokens(file)) == null || tokensInFile.isEmpty()) continue;
            Iterator<Map.Entry<Integer, LiteralToken>> iterator = tokensInFile.entrySet().iterator();
            while (iterator.hasNext()) {
                LiteralToken startToken = iterator.next().getValue();
                if (!startToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) && !startToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT)) continue;
                LiteralToken currentToken = startToken;
                StringBuilder commentSB = new StringBuilder();
                commentSB.append(currentToken.getStringToken()).append(" ");
                while (iterator.hasNext()) {
                    currentToken = iterator.next().getValue();
                    if (!currentToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.MULTILINE_COMMENT) && !currentToken.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.SINGLE_COMMENT)) break;
                    commentSB.append(currentToken.getStringToken()).append(" ");
                }
                commentBlocks.add(new CommentBlock(file, commentSB.toString(), startToken));
            }
        }
        Iterator commentIterator = commentBlocks.iterator();
        ArrayList<CommentBlock> duplicateComments = new ArrayList<CommentBlock>();
        if (commentIterator.hasNext()) {
            duplicateComments.add((CommentBlock)commentIterator.next());
        }
        while (commentIterator.hasNext()) {
            CommentBlock currentComment = (CommentBlock)commentIterator.next();
            if (((CommentBlock)duplicateComments.get(0)).getComment().equals(currentComment.getComment())) {
                duplicateComments.add(currentComment);
                continue;
            }
            if (duplicateComments.size() > 1) {
                this.addDuplicateCommentsHit(duplicateComments);
            }
            duplicateComments.clear();
            duplicateComments.add(currentComment);
        }
        if (duplicateComments.size() > 1) {
            this.addDuplicateCommentsHit(duplicateComments);
        }
    }

    public int compare(CommentBlock o1, CommentBlock o2) {
        int commentCompare = o1.getComment().compareTo(o2.getComment());
        if (commentCompare != 0) {
            return commentCompare;
        }
        commentCompare = o1.path.compareTo(o2.path);
        if (commentCompare != 0) {
            return commentCompare;
        }
        return o1.getStartToken().getOffsetFile() - o2.getStartToken().getOffsetFile();
    }

    private void addDuplicateCommentsHit(List<CommentBlock> duplicateComments) {
        CommentBlock duplicateComment2;
        StringBuilder hitMessageSB = new StringBuilder();
        hitMessageSB.append("Duplicate comment found:").append("\n");
        for (CommentBlock duplicateComment2 : duplicateComments) {
            String message = this.link("at line " + duplicateComment2.getStartToken().getLineNumber() + " of " + LintUtils.getFileShortName(duplicateComment2.getPath().path), duplicateComment2.getPath().path, duplicateComment2.getStartToken().getLineNumber());
            hitMessageSB.append(message).append("\n");
        }
        duplicateComment2 = duplicateComments.get(0);
        this.addHit(duplicateComment2.getPath(), duplicateComment2.getStartToken().getLineNumber(), hitMessageSB.toString(), null);
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private static class CommentBlock {
        private ParserPath path;
        private String comment;
        private LiteralToken startToken;

        public CommentBlock(ParserPath path, String comment, LiteralToken startToken) {
            this.path = path;
            this.comment = comment;
            this.startToken = startToken;
        }

        public ParserPath getPath() {
            return this.path;
        }

        public String getComment() {
            return this.comment;
        }

        public LiteralToken getStartToken() {
            return this.startToken;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CommentBlock)) {
                return false;
            }
            CommentBlock block = (CommentBlock)object;
            if (!this.path.equals((Object)block.getPath())) {
                return false;
            }
            if (!this.comment.equals(block.getComment())) {
                return false;
            }
            if (this.startToken.getOffsetFile() != block.getStartToken().getOffsetFile()) {
                return false;
            }
            return this.startToken.equals(block.getStartToken());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.comment.hashCode();
            result = 31 * result + this.startToken.hashCode();
            return result;
        }
    }
}

