/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="22.1.34")
@CheckID(value="R.1180")
@CheckName(value="R.1180")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.FIELD, RuleLabel.CLASS, RuleLabel.RAL, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use user defined UVM RAL class type variables outside of tests")
@CheckDescription(value="Do not use fields of type extending from uvm_reg_block, uvm_reg, uvm_reg_field, uvm_reg_map outside of test classes.\n\nExamples\nclass my_monitor extends uvm_monitor;\n  my_reg_block block; // not allowed\nendclass\n\nclass my_test extends uvm_test;\n  my_reg_block block; // allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_R_1180
extends OVMComplianceCheck {
    private Set<String> ralClassNames = new HashSet<String>(Arrays.asList("uvm_reg_block", "uvm_reg", "uvm_reg_field", "uvm_reg_map"));
    private Set<RfClass> ralClasses = new HashSet<RfClass>();

    public Check_R_1180(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.getLibraryKind() != 2) {
            return;
        }
        RfClass xvmTest = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_test", true);
        final HashSet<RfClass> validScopes = new HashSet<RfClass>();
        validScopes.add(xvmTest);
        for (String name : this.ralClassNames) {
            RfClass ralClass = this.fOVMProject.getRfProject().getClass(name, false);
            if (ralClass == null) continue;
            this.ralClasses.add(ralClass);
            validScopes.add(ralClass);
        }
        RfHidVisitor callVisitor = new RfHidVisitor(){
            private IRfNamedElement scope;

            @Override
            public void setHolder(IHidHolder holder) {
                if (holder instanceof HidHolder) {
                    this.scope = ((HidHolder)holder).getScope();
                }
            }

            public boolean visit(RfHid rfHid) {
                String name = LintUtils.getFileShortName(this.parserPath.path);
                if (Check_R_1180.this.fOVMProject.isOVMFile(name)) {
                    return true;
                }
                if (Check_R_1180.this.checkPrewaivers(this.parserPath)) {
                    return true;
                }
                HidOccurrence occurrence = rfHid.getOccurrence();
                if (occurrence.hasQualifier(HidQualifierCache.CONSTRUCTOR_DECLARATION)) {
                    return true;
                }
                IRfNamedElement rfNamedElement = rfHid.getElement();
                if (rfNamedElement == null || !(rfNamedElement instanceof RfField)) {
                    return true;
                }
                Check_R_1180.this.notifyCheckAlive();
                RfClass enclosingClass = (RfClass)this.scope.getEnclosingScope(RfClass.class);
                if (enclosingClass == null || LintUtils.isSubClassOfAny(enclosingClass, validScopes)) {
                    return true;
                }
                RfClass classFound = LintUtils.getFieldFinalClassTypeOrNull((RfField)rfNamedElement);
                if (classFound == null || Check_R_1180.this.ralClasses.contains(classFound)) {
                    return true;
                }
                for (RfClass ralClass : Check_R_1180.this.ralClasses) {
                    if (classFound == null || !LintUtils.isSubClassOf(classFound, ralClass)) continue;
                    Check_R_1180.this.addHit(this.parserPath, rfHid, "Do not use field '" + LintUtils.getNamedElementFullName((RfNamedElement)rfNamedElement) + "' of type '" + LintUtils.getNamedElementFullName(classFound) + "' outside of uvm_test!");
                    break;
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, callVisitor);
        IRfNamedElementVisitor visitor = namedElement -> {
            if (namedElement.getFile() == null || this.checkPrewaivers(namedElement.getFile().getParserPath())) {
                return true;
            }
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            this.notifyCheckAlive();
            RfClass enclosingClass = namedElement.getEnclosingScope(RfClass.class);
            if (enclosingClass == null || LintUtils.isSubClassOfAny(enclosingClass, validScopes)) {
                return true;
            }
            RfClass classFound = LintUtils.getFieldFinalClassTypeOrNull((RfField)namedElement);
            if (classFound == null || this.ralClasses.contains(classFound)) {
                return true;
            }
            for (RfClass ralClass : this.ralClasses) {
                if (classFound == null || !LintUtils.isSubClassOf(classFound, ralClass)) continue;
                this.addHit(namedElement.getFile().getParserPath(), namedElement.getLine(), "Declaration of field '" + LintUtils.getNamedElementFullName(namedElement) + "' uses type '" + LintUtils.getNamedElementFullName(classFound) + "' and is outside of uvm_test!", null);
                break;
            }
            return true;
        };
        this.fOVMProject.getRfProject().accept(visitor);
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

