/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.IRfDefElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceHolder;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="22.1.34")
@CheckID(value="R.1181")
@CheckName(value="R.1181")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.PARENTHESIS})
@CheckTitle(value="Open parenthesis should be on the same line with their associated element")
@CheckDescription(value="This rule checks that the open parenthesis is on the same line with the declaration of: methods, specialized classes, modules, interfaces, fields and instances, and for method and macro calls.\n\nExample:\nfunction void add\n (int a, int b); // not allowed\nendfunction\n\nfunction void add( // allowed\n  int a, int b\n);\nendfunction\n\nCheck supports pre-waiving.")
public class Check_R_1181
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    public Check_R_1181(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().accept(namedElement -> {
            RfDefElement declaration = namedElement.getDeclaration();
            if (declaration == null) {
                return true;
            }
            if (declaration.getReparseInfo() != null) {
                return true;
            }
            if (this.checkPreWaivers(declaration.getParserPath())) {
                return true;
            }
            this.notifyCheckAlive();
            if (namedElement instanceof RfFunction || namedElement instanceof RfModule || namedElement instanceof RfInterface) {
                this.checkElement(namedElement, declaration.getParserPath());
            } else if (namedElement instanceof RfClass) {
                this.checkClass((RfClass)namedElement, declaration.getParserPath());
            } else if (namedElement instanceof RfField) {
                RfField field = (RfField)namedElement;
                RfHidHolder paramValueHolder = field.getDataType().getParamValuesHolder();
                RfNamedElement fieldType = LintUtils.getAssociatedFinalType((RfField)namedElement);
                if (fieldType instanceof RfSpecializedClass) {
                    this.checkField((RfField)namedElement, declaration.getParserPath(), fieldType, fieldType.getName());
                } else if (fieldType instanceof RfInstanceHolder) {
                    if (paramValueHolder != null && !paramValueHolder.isEmpty()) {
                        this.checkField((RfInstance)namedElement, declaration.getParserPath(), null, namedElement.getName());
                        this.checkField((RfField)namedElement, declaration.getParserPath(), null, fieldType.getName());
                    } else {
                        this.checkElement(namedElement, declaration.getParserPath());
                    }
                }
            }
            return true;
        });
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (!hidObject.isMethodCall(false)) {
                    return true;
                }
                if (hidObject.getReparseInfo() != null) {
                    return true;
                }
                if (Check_R_1181.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1181.this.notifyCheckAlive();
                IRfNamedElement element = hidObject.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                LiteralToken token = Check_R_1181.this.getWSParser().getTokenContainingOffset(hidObject.getOccurrence().getOffset(), this.parserPath);
                if (token == null) {
                    return true;
                }
                int elementLine = token.getLineNumber();
                if (token.getStringToken().contains("(") || token.getStringToken().contains(";")) {
                    return true;
                }
                token = Check_R_1181.this.getWSParser().getNextToken(token, this.parserPath);
                if (token == null) {
                    return true;
                }
                while (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) && (token = Check_R_1181.this.getWSParser().getNextToken(token, this.parserPath)) != null) {
                }
                if (token == null) {
                    return true;
                }
                if (!token.getStringToken().startsWith("(")) {
                    return true;
                }
                if (elementLine == token.getLineNumber()) {
                    return true;
                }
                Check_R_1181.this.addHit(this.parserPath, token.getLineNumber(), "The open parenthesis should be on the same line with the '" + LintUtils.getNamedElementFullName((RfFunction)element) + "' method call!", null);
                return true;
            }
        });
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), new MacroVisitor());
        MacroDefVisitor visitor = new MacroDefVisitor();
        RfProject rfProject = this.fOVMProject.getRfProject();
        try {
            rfProject.accept(visitor);
        }
        catch (Exception e) {
            this.fOVMProject.notifyCheckException(this, e);
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void checkElement(RfNamedElement element, ParserPath parserPath) {
        int startOffset = element.getStartOffset();
        if (startOffset == 0) {
            return;
        }
        LiteralToken token = this.getWSParser().getTokenContainingOffset(startOffset, parserPath);
        if (token == null) {
            return;
        }
        int elementLine = token.getLineNumber();
        while (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) || !token.getStringToken().contains("(")) {
            if (token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) && token.getStringToken().contains(";")) {
                return;
            }
            token = this.getWSParser().getNextToken(token, parserPath);
            if (token != null) continue;
        }
        if (token == null) {
            return;
        }
        if (elementLine == token.getLineNumber()) {
            return;
        }
        this.addHit(parserPath, token.getLineNumber(), "The open parenthesis should be on the same line with the '" + LintUtils.getNamedElementFullName(element) + "' " + LintUtils.getElementKind(element) + " declaration!", null);
    }

    private void checkField(RfField field, ParserPath parserPath, RfNamedElement fieldType, String searchedToken) {
        int startOffset = field.getStartOffset();
        if (startOffset == 0) {
            return;
        }
        LiteralToken token = this.getWSParser().getTokenContainingOffset(startOffset, parserPath);
        if (token == null) {
            return;
        }
        if (fieldType != null) {
            token = this.getWSParser().getPrevToken(token, parserPath);
        }
        if (token == null) {
            return;
        }
        while (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) || !token.getStringToken().startsWith(searchedToken)) {
            if (token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) && token.getStringToken().contains(";")) {
                return;
            }
            token = fieldType != null ? this.getWSParser().getPrevToken(token, parserPath) : this.getWSParser().getNextToken(token, parserPath);
            if (token != null) continue;
        }
        if (token == null) {
            return;
        }
        int elementLine = token.getLineNumber();
        while (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) || !token.getStringToken().contains("(")) {
            if (token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) && token.getStringToken().contains(";")) {
                return;
            }
            token = this.getWSParser().getNextToken(token, parserPath);
            if (token != null) continue;
        }
        if (token == null) {
            return;
        }
        if (elementLine == token.getLineNumber()) {
            return;
        }
        if (fieldType == null) {
            this.addHit(parserPath, token.getLineNumber(), "The open parenthesis should be on the same line with the '" + LintUtils.getNamedElementFullName(field) + "' " + LintUtils.getElementKind(field) + " declaration!", null);
        } else {
            this.addHit(parserPath, token.getLineNumber(), "The open parenthesis should be on the same line with the '" + LintUtils.getNamedElementFullName(fieldType) + "' " + LintUtils.getElementKind(field) + " type declaration!", null);
        }
    }

    private void checkClass(RfClass classs, ParserPath parserPath) {
        int startOffset;
        if (classs.getParent() != null) {
            this.checkParentClass(classs, parserPath);
        }
        if ((startOffset = classs.getStartOffset()) == 0) {
            return;
        }
        LiteralToken token = this.getWSParser().getTokenContainingOffset(startOffset, parserPath);
        if (token == null) {
            return;
        }
        int elementLine = token.getLineNumber();
        while (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) || !token.getStringToken().contains("(")) {
            if (token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) && (token.getStringToken().contains(";") || token.getStringToken().equals("extends"))) {
                return;
            }
            token = this.getWSParser().getNextToken(token, parserPath);
            if (token != null) continue;
        }
        if (token == null) {
            return;
        }
        if (elementLine == token.getLineNumber()) {
            return;
        }
        this.addHit(parserPath, token.getLineNumber(), "The open parenthesis should be on the same line with the '" + LintUtils.getNamedElementFullName(classs) + "' " + LintUtils.getElementKind(classs) + " declaration!", null);
    }

    private void checkParentClass(RfClass classs, ParserPath parserPath) {
        int startOffset = classs.getExtendedType().getOffset();
        if (startOffset == 0) {
            return;
        }
        LiteralToken token = this.getWSParser().getTokenContainingOffset(startOffset, parserPath);
        if (token == null) {
            return;
        }
        int elementLine = token.getLineNumber();
        while (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) || !token.getStringToken().contains("(")) {
            if (token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) && token.getStringToken().contains(";")) {
                return;
            }
            token = this.getWSParser().getNextToken(token, parserPath);
            if (token != null) continue;
        }
        if (token == null) {
            return;
        }
        if (elementLine == token.getLineNumber()) {
            return;
        }
        this.addHit(parserPath, token.getLineNumber(), "The open parenthesis should be on the same line with the '" + LintUtils.getNamedElementFullName(classs.getParent()) + "' parent class!", null);
    }

    private void checkReparserInfo(ReparseInfo reparseInfo, ParserPath parserPath, int offset) {
        ReparseInfo.ReparseElement reparseElement = reparseInfo.getReparseStack()[0];
        if (reparseElement == null) {
            return;
        }
        String[] params = reparseElement.getReparseMacroParams();
        if (params == null || params.length == 0 || params[0] == null) {
            return;
        }
        LiteralToken token = this.getWSParser().getToken(offset, parserPath);
        if (token == null) {
            return;
        }
        if (token.getStringToken().contains("(")) {
            return;
        }
        int elementLine = token.getLineNumber();
        token = this.getWSParser().getNextToken(token, parserPath);
        if (token == null) {
            return;
        }
        while (!token.getZone().equals((Object)SVTBWhitespaceParser.ZoneType.CODE) && (token = this.getWSParser().getNextToken(token, parserPath)) != null) {
        }
        if (token == null) {
            return;
        }
        if (!token.getStringToken().startsWith("(")) {
            return;
        }
        if (elementLine == token.getLineNumber()) {
            return;
        }
        this.addHit(parserPath, token.getLineNumber(), "The open parenthesis should be on the same line with the '" + reparseElement.getReparseMacroName() + "' macro call!", null);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private class MacroDefVisitor
    implements IRfDefElementVisitor {
        private MacroDefVisitor() {
        }

        @Override
        public boolean visit(RfDefElement defElement) throws Exception {
            return false;
        }

        @Override
        public void preVisit(RfDefElement defElement) throws Exception {
            Check_R_1181.this.notifyCheckAlive();
            ReparseInfo reparseInfo = defElement.getReparseInfo();
            if (reparseInfo == null) {
                return;
            }
            Check_R_1181.this.checkReparserInfo(reparseInfo, defElement.getParserPath(), defElement.getStartOffset());
        }

        @Override
        public void postVisit(RfDefElement defElement) throws Exception {
        }
    }

    private class MacroVisitor
    implements IHidVisitor<IHidObject> {
        private ParserPath path;

        private MacroVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.path = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            HidOccurrence occurence;
            IReparseInfo reparserInfo;
            if (hidObject instanceof Hid) {
                reparserInfo = ((Hid)hidObject).getReparseInfo();
                occurence = ((Hid)hidObject).getOccurrence();
                if (!(reparserInfo instanceof ReparseInfo)) {
                    return true;
                }
                Check_R_1181.this.checkReparserInfo((ReparseInfo)reparserInfo, this.path, occurence.getOffset());
            }
            if (hidObject instanceof HidOperator) {
                reparserInfo = ((HidOperator)hidObject).getReparseInfo();
                occurence = ((HidOperator)hidObject).getOccurrence();
                if (!(reparserInfo instanceof ReparseInfo)) {
                    return true;
                }
                Check_R_1181.this.checkReparserInfo((ReparseInfo)reparserInfo, this.path, occurence.getOffset());
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

