/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractRangeArrayCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IndexType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.35")
@CheckID(value="R.1182")
@CheckName(value="R.1182")
@CheckLabel(labels={RuleLabel.AGGREGATE_DATA_TYPE, RuleLabel.ARRAY, RuleLabel.RANGE})
@CheckTitle(value="Declare packed arrays as little endian")
@CheckDescription(value="Declare packed arrays as little endian\n\nExample:\nlogic [31:0] u32_word; //allowed\nlogic [0:31] u32_word; //not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1182
extends AbstractRangeArrayCheck {
    public Check_R_1182(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected List<IndexType> getDimensions(DataType datatype) {
        return datatype.getPackedDimension();
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    protected void addHitCheck(IHidObject rangeObj, RfNamedElement namedElement) {
        if (((RfHidOperator)rangeObj).isRangeOrPartSelect()) {
            int rhInt;
            int lhInt;
            IHidObject lhValue = ((RfHidOperator)rangeObj).getLHValue();
            IHidObject rhValue = ((RfHidOperator)rangeObj).getFirstRHValue();
            if (!(lhValue instanceof RfHidImplicit) || !(rhValue instanceof RfHidImplicit)) {
                return;
            }
            try {
                lhInt = Integer.parseInt(((RfHidImplicit)lhValue).getName());
                rhInt = Integer.parseInt(((RfHidImplicit)rhValue).getName());
            }
            catch (Exception exception) {
                return;
            }
            if (lhInt >= rhInt) {
                return;
            }
            this.addHit(namedElement, "Packed array '" + LintUtils.getNamedElementFullName(namedElement) + "' must be declared as little endian!");
        }
    }
}

