/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.ArrayList;
import java.util.Collection;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="22.1.36")
@CheckID(value="R.1185")
@CheckName(value="R.1185")
@CheckLabel(labels={RuleLabel.STYLING, RuleLabel.METHOD, RuleLabel.PARENTHESIS})
@CheckTitle(value="Never place spaces on either side of method declaration's parenthesis")
@CheckDescription(value="Never place spaces on either side of method declaration's parenthesis\n\nExample:\nfunction void foo(); //allowed\nfunction void foo () ; //not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1185
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    public Check_R_1185(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    private boolean hasWhiteSpacesBefore(LiteralToken token) {
        return token.getNoSpacesBefore() > 0 || token.getNoTabsBefore() > 0 || token.isFirstTokenOnLine();
    }

    private boolean hasWhiteSpacesAfter(LiteralToken token) {
        return token.getNoSpacesAfter() > 0 || token.getNoTabsAfter() > 0 || token.isLastTokenOnLine();
    }

    @Override
    public void performCheckImpl() {
        ArrayList<RfNamedElement> allMethods = new ArrayList<RfNamedElement>();
        allMethods.addAll(this.fOVMProject.getAllFunctions());
        allMethods.addAll(this.fOVMProject.getAllTasks());
        for (RfNamedElement method : allMethods) {
            ParserPath methodPath;
            RfFileDef file = method.getFile();
            if (file == null || this.checkPrewaivers(methodPath = file.getParserPath())) continue;
            Collection methodDeclarations = method.getDeclarations();
            block1: for (RfDefElement declaration : methodDeclarations) {
                long count;
                if (declaration == null || declaration.getReparseInfo() != null) continue;
                int methodOffset = declaration.getStartOffset();
                LiteralToken declarationToken = this.getWSParser().getTokenContainingOffset(methodOffset, methodPath);
                if (declarationToken == null) continue;
                int paranthesis = 0;
                String declarationString = declarationToken.getStringToken();
                if (declarationToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                    if (declarationString.startsWith("(") && paranthesis == 0 && this.hasWhiteSpacesBefore(declarationToken)) {
                        this.addHit(methodPath, declarationToken.getLineNumber(), "Do not place spaces on either side of '" + method.getName() + "' method declaration's paranthesis!", null);
                        continue;
                    }
                    count = declarationString.chars().filter(ch -> ch == 40).count();
                    paranthesis = (int)((long)paranthesis + count);
                    if (declarationString.endsWith("(") && paranthesis - 1 == 0 && this.hasWhiteSpacesAfter(declarationToken)) {
                        this.addHit(methodPath, declarationToken.getLineNumber(), "Do not place spaces on either side of '" + method.getName() + "' method declaration's paranthesis!", null);
                        continue;
                    }
                    if (declarationString.startsWith(")") && paranthesis - 1 == 0 && this.hasWhiteSpacesBefore(declarationToken)) {
                        this.addHit(methodPath, declarationToken.getLineNumber(), "Do not place spaces on either side of '" + method.getName() + "' method declaration's paranthesis!", null);
                        continue;
                    }
                    count = declarationString.chars().filter(ch -> ch == 41).count();
                    paranthesis = (int)((long)paranthesis - count);
                    if (declarationString.endsWith(")") && paranthesis == 0 && this.hasWhiteSpacesAfter(declarationToken)) {
                        this.addHit(methodPath, declarationToken.getLineNumber(), "Do not place spaces on either side of '" + method.getName() + "' method declaration's paranthesis!", null);
                        continue;
                    }
                    if (declarationString.endsWith(";")) continue;
                }
                while ((declarationToken = this.getWSParser().getNextToken(declarationToken, methodPath)) != null) {
                    declarationString = declarationToken.getStringToken();
                    if (declarationToken.getZone() == SVTBWhitespaceParser.ZoneType.CODE) {
                        if (declarationString.startsWith("(") && paranthesis == 0 && this.hasWhiteSpacesBefore(declarationToken)) {
                            this.addHit(methodPath, declarationToken.getLineNumber(), "Do not place spaces on either side of '" + method.getName() + "' method declaration's paranthesis!", null);
                            continue block1;
                        }
                        count = declarationString.chars().filter(ch -> ch == 40).count();
                        paranthesis = (int)((long)paranthesis + count);
                        if (declarationString.endsWith("(") && paranthesis - 1 == 0 && this.hasWhiteSpacesAfter(declarationToken)) {
                            this.addHit(methodPath, declarationToken.getLineNumber(), "Do not place spaces on either side of '" + method.getName() + "' method declaration's paranthesis!", null);
                            continue block1;
                        }
                        if (declarationString.startsWith(")") && paranthesis - 1 == 0 && this.hasWhiteSpacesBefore(declarationToken)) {
                            this.addHit(methodPath, declarationToken.getLineNumber(), "Do not place spaces on either side of '" + method.getName() + "' method declaration's paranthesis!", null);
                            continue block1;
                        }
                        count = declarationString.chars().filter(ch -> ch == 41).count();
                        paranthesis = (int)((long)paranthesis - count);
                        if (declarationString.endsWith(")") && paranthesis == 0 && this.hasWhiteSpacesAfter(declarationToken)) {
                            this.addHit(methodPath, declarationToken.getLineNumber(), "Do not place spaces on either side of '" + method.getName() + "' method declaration's paranthesis!", null);
                            continue block1;
                        }
                    }
                    if (declarationToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE || !declarationString.endsWith(";")) continue;
                    continue block1;
                }
            }
        }
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

