/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

@CheckVersion(value="22.1.36")
@CheckID(value="R.1186")
@CheckName(value="R.1186")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.INCLUDE})
@CheckTitle(value="Do not include the same file multiple times")
@CheckDescription(value="Including a file multiple times is not recommended. If there's any source code that must be shared, it should be found in a package that can be imported.")
@CheckReapplyDisable
public class Check_R_1186
extends OVMComplianceCheck {
    public Check_R_1186(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap includesByPath = new HashMap();
        VlogPreprocessingInfo preprocessingTable = this.fOVMProject.getRfProject().getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        if (topFile == null) {
            return;
        }
        ArrayList<VlogFileInstance> includedfiles = new ArrayList<VlogFileInstance>();
        includedfiles.addAll(topFile.getIncludedInstances());
        int i = 0;
        while (i < includedfiles.size()) {
            String name = ((VlogFileInstance)includedfiles.get(i)).getShortFileName();
            List<VlogFileInstance> includedInstances = ((VlogFileInstance)includedfiles.get(i)).getIncludedInstances();
            if (name.startsWith("__vlog__") && name.endsWith(".libfile")) {
                includedfiles.addAll(includedInstances);
            }
            ParserPath parserPath = ((VlogFileInstance)includedfiles.get(i)).getParserPath();
            File file = new File(parserPath.path);
            if (file.exists()) {
                includedfiles.addAll(includedInstances);
                this.notifyCheckAlive();
                for (VlogFileInstance instance : includedInstances) {
                    LinkedHashMap<ParserPath, Integer> pathIncludes = (LinkedHashMap<ParserPath, Integer>)includesByPath.get(instance.getParserPath());
                    if (pathIncludes == null) {
                        pathIncludes = new LinkedHashMap<ParserPath, Integer>();
                        includesByPath.put(instance.getParserPath(), pathIncludes);
                    }
                    int includeLine = instance.getIncludingScope().getIncludingLine();
                    pathIncludes.put(parserPath, includeLine);
                }
            }
            ++i;
        }
        for (Map.Entry entry : includesByPath.entrySet()) {
            if (((Map)entry.getValue()).size() < 2) continue;
            StringBuilder message = new StringBuilder();
            message.append("The '" + LintUtils.getFileShortName(((ParserPath)entry.getKey()).path) + "' is included in multiple files:");
            for (Map.Entry fileEntry : ((Map)entry.getValue()).entrySet()) {
                message.append(String.valueOf(System.lineSeparator()) + this.link("at line " + fileEntry.getValue() + " in file '" + LintUtils.getFileShortName(((ParserPath)fileEntry.getKey()).path) + "'", ((ParserPath)fileEntry.getKey()).path, (Integer)fileEntry.getValue()));
            }
            this.addHit((ParserPath)entry.getKey(), 1, message.toString(), null);
        }
    }
}

