/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.standard.checks.AbstractBuildPhaseCreationCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="22.1.38")
@CheckID(value="R.1187")
@CheckName(value="R.1187")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.BUILD_PHASE, RuleLabel.REGISTER_BLOCK, RuleLabel.VERIFICATION, RuleLabel.RAL})
@CheckTitle(value="The testbench must instantiate and build the register block in the build_phase method")
@CheckDescription(value="The UVM testbench should instantiate all of the fields of type register block declared inside of it using the factory and should call the build method of the register model.\nThe factory method call type_id::create and the call to build should be made from the build_phase method of the class.\n\nExamples:\nmy_reg_block_class reg_block;\nfunction void build_phase(uvm_phase phase);\n  reg_block = my_reg_block_class::type_id::create(\"reg_block\");\n  reg_block.build();\nendfunction\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="allowIndirectCallInstantiation", defaultValue="true", isVisible=false), @CheckParameterOverride(name="testbenchClassNamePattern", isVisible=true)})
@CheckReapplyDisable
public class Check_R_1187
extends AbstractBuildPhaseCreationCheck {
    private RfClass regBlockClass;

    public Check_R_1187(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
        this.shouldSkip = true;
    }

    @Override
    protected Set<RfField> getFields(RfClass classs) {
        HashSet<RfField> fields = new HashSet<RfField>();
        List<RfField> candidates = classs.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (candidates != null && !candidates.isEmpty()) {
            for (RfField field : candidates) {
                RfClass fieldType = LintUtils.getFieldFinalClassTypeOrNull(field);
                if (fieldType == null || !LintUtils.isSubClassOf(fieldType, this.regBlockClass)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    @Override
    protected Collection<RfClass> getClasses() {
        this.regBlockClass = this.fOVMProject.getRfProject().getClass("uvm_reg_block", false);
        return this.getClassesWithPatterns("testbenchClassNamePattern").values();
    }

    @Override
    protected boolean checkElementType(RfClass rightElement) {
        return LintUtils.isSubClassOf(rightElement, this.regBlockClass);
    }

    @Override
    public void addMissingFieldHit(RfClass classs) {
    }

    @Override
    public void addNotProperlyInstantiatedFieldHit(RfClass classs, RfField field) {
        this.addHit(field, "Register block '" + LintUtils.getNamedElementFullName(field) + "' is not properly instantiated in testbench '" + LintUtils.getNamedElementFullName(classs) + "'!");
    }

    @Override
    public void addInstantiationOutsideFunctionHit(ParserPath parserPath, IRfNamedElement element, RfHid hid) {
        this.addHit(parserPath, hid, "Register block '" + element.getName() + "' is instantiated outside a function!");
    }

    @Override
    public void addInstantiationOutsideBuildPhaseHit(ParserPath parserPath, IRfNamedElement element, RfHid hid) {
    }

    @Override
    public void additionalHits(RfClass classs) {
        for (RfField field : this.fieldsCreated) {
            this.addHit(field, "Register block '" + LintUtils.getNamedElementFullName(field) + "' is not built in testbench '" + LintUtils.getNamedElementFullName(classs) + "'!");
        }
    }

    @Override
    public void additionalCheck(RfHid hid, RfFunction function) {
        if (this.fieldsCreated.isEmpty()) {
            return;
        }
        if (!"build".equals(function.getName())) {
            return;
        }
        Hid parentHid = hid.getParentHid();
        if (parentHid == null || !(parentHid instanceof RfHid)) {
            return;
        }
        IRfNamedElement element = ((RfHid)parentHid).getElement();
        if (element == null || !(element instanceof RfField)) {
            return;
        }
        if (!this.fieldsCreated.contains(element)) {
            return;
        }
        this.fieldsCreated.remove(element);
    }
}

