/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="22.1.38")
@CheckID(value="R.1188")
@CheckName(value="R.1188")
@CheckLabel(labels={RuleLabel.UVM_SEQUENCE, RuleLabel.METHOD, RuleLabel.OBJECTION, RuleLabel.VERIFICATION, RuleLabel.PHASE})
@CheckTitle(value="Set the starting_phase member of the sequence object before starting the sequence.")
@CheckDescription(value="Always set the starting_phase member of the sequence object before starting the sequence, so that the sequence can raise and drop objections.\nPrior to uvm-1.2, starting_phase was a member of the class uvm_sequence_base.\nFrom uvm-1.2 onward, the starting_phase variable is deprecated and must be set using the set_starting_phase method.\n\nExamples:\nseq1.set_starting_phase(phase);\nseq1.start(sequencer); // allowed\nseq2.starting_phase = phase;\nseq2.start(sequencer); // allowed\nseq3.start(sequencer); // not allowed\n\nCheck supports pre-waiving.")
public class Check_R_1188
extends OVMComplianceCheck {
    private static final String SET_STARTING_PHASE = "uvm_pkg::uvm_sequence_base.set_starting_phase";
    private static final String STARTING_PHASE = "uvm_pkg::uvm_sequence_base.starting_phase";
    private static final String START = "uvm_pkg::uvm_sequence_base.start";

    public Check_R_1188(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass[] allClasses;
        RfClass[] rfClassArray = allClasses = this.fOVMProject.getRfProject().getAllClasses();
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass classs = rfClassArray[n2];
            if (classs == null) {
                return;
            }
            this.notifyCheckAlive();
            RfFileDef fileDef = classs.getFile();
            if (fileDef != null && !this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this) && !this.fOVMProject.isOVMElement(classs)) {
                this.handleClass(classs);
            }
            ++n2;
        }
    }

    private void handleClass(RfClass baseClass) {
        final HashMap scopetoClassesMap = new HashMap();
        baseClass.visitHidObject(null, new IHidVisitor<IHidObject>(){
            private ParserPath parserPath;
            private RfNamedElement scope;

            public boolean visit(IHidObject iHid) {
                Object hid;
                if (iHid instanceof RfHidOperator) {
                    hid = (RfHidOperator)iHid;
                    if (!hid.isAssignment()) {
                        return true;
                    }
                    IHidObject lhVal = hid.getLHValue();
                    if (lhVal == null) {
                        return true;
                    }
                    if (!(lhVal instanceof RfHid)) {
                        return true;
                    }
                    RfHid leftHid = (RfHid)lhVal;
                    IRfNamedElement element = leftHid.getElement();
                    if (!(element instanceof RfField)) {
                        return true;
                    }
                    if (!((RfField)element).getFullName().equals(Check_R_1188.STARTING_PHASE)) {
                        return true;
                    }
                    HidAccess access = leftHid.getParentAccess();
                    if (access == null) {
                        return true;
                    }
                    Hid accessHid = access.getParentHid();
                    if (accessHid == null) {
                        return true;
                    }
                    IRfNamedElement accessElement = accessHid.getElement();
                    if (!(accessElement instanceof RfField)) {
                        return true;
                    }
                    String accessName = ((RfField)accessElement).getFullName();
                    if (scopetoClassesMap.get(this.scope) == null) {
                        scopetoClassesMap.put(this.scope, new HashSet());
                    }
                    Set classes = (Set)scopetoClassesMap.get(this.scope);
                    classes.add(accessName);
                }
                if (!(iHid instanceof RfHid)) {
                    return true;
                }
                hid = (RfHid)iHid;
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfFunction)) {
                    return true;
                }
                String elementName = ((RfFunction)element).getFullName();
                if (elementName.equals(Check_R_1188.START)) {
                    this.check((RfHid)((Object)hid));
                    return true;
                }
                if (!elementName.equals(Check_R_1188.SET_STARTING_PHASE)) {
                    return true;
                }
                HidAccess access = hid.getParentAccess();
                if (access == null) {
                    return true;
                }
                Hid accessHid = access.getParentHid();
                IRfNamedElement accessElement = accessHid.getElement();
                if (!(accessElement instanceof RfField)) {
                    return true;
                }
                String accessName = ((RfField)accessElement).getFullName();
                if (scopetoClassesMap.get(this.scope) == null) {
                    scopetoClassesMap.put(this.scope, new HashSet());
                }
                Set classes = (Set)scopetoClassesMap.get(this.scope);
                classes.add(accessName);
                return true;
            }

            private void check(RfHid hid) {
                HidAccess access = hid.getParentAccess();
                if (access == null) {
                    return;
                }
                Hid accessHid = access.getParentHid();
                if (accessHid == null) {
                    return;
                }
                IRfNamedElement accessElement = accessHid.getElement();
                if (!(accessElement instanceof RfField)) {
                    return;
                }
                String accessName = ((RfField)accessElement).getFullName();
                RfNamedElement currentScope = this.scope;
                while (currentScope != null) {
                    Set classes = (Set)scopetoClassesMap.get(currentScope);
                    if (classes != null && classes.contains(accessName)) {
                        return;
                    }
                    currentScope = currentScope.getEnclosingScope();
                }
                Check_R_1188.this.addHit(this.parserPath, hid, "Sequence '" + accessName + "' is started without setting the 'starting_phase' member first!");
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public void setHolder(IHidHolder holder) {
                this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
            }

            public Class<IHidObject> getType() {
                return IHidObject.class;
            }
        });
    }
}

