/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IReparseInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="23.1.1")
@CheckID(value="R.1189")
@CheckName(value="R.1189")
@CheckLabel(labels={RuleLabel.ARCHITECTURE, RuleLabel.AGENT, RuleLabel.VIRTUAL_INTERFACE, RuleLabel.VERIFICATION})
@CheckTitle(value="An agent should check that its virtual interface has been set")
@CheckDescription(value="An agent should get the virtual interface from its configuration object and assign the virtual interface variables in its driver and monitor.\nIf the virtual interface is null the agent should report a fatal error, since simulation will be unable to continue and user-defined error reports are easier to debug than simulator crashes.\n\nExample:\n\nclass bus_agent extends uvm_agent; // allowed\n  bus_config m_config;\n\n  function void bus_agent::build_phase(uvm_phase phase);\n    if (!uvm_config_db #(bus_config)::get(this, \"\", \"config\", m_config))\n      `uvm_error(get_type_name(),\"bus config not found\")\n    if (m_config.vif == null)\n      `uvm_fatal(get_type_name(), \"bus virtual interface not set\")\n\nCheck supports pre-waiving.")
public class Check_R_1189
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="Allow setting the virtual interface in any method of the agent.", name="allowAnyMethod", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private Boolean pAllowAnyMethod;
    private Set<RfHid> configHid;
    private Set<RfHid> checkedConfigHid;
    private boolean visiting;

    public Check_R_1189(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.fOVMProject.fOvmAgent == null) {
            return;
        }
        Set<RfClass> allAgents = this.fOVMProject.getAllXVMSubClasses(this.fOVMProject.fOvmAgent);
        if (allAgents.isEmpty()) {
            return;
        }
        this.configHid = new HashSet<RfHid>();
        this.checkedConfigHid = new HashSet<RfHid>();
        for (RfClass agent : allAgents) {
            if (agent.hasVirtualQualifier()) continue;
            this.notifyCheckAlive();
            if (agent.getFile() != null && this.checkPrewaivers(agent.getFile().getParserPath())) continue;
            this.visiting = true;
            HashSet<RfFunction> visited = new HashSet<RfFunction>();
            if (this.pAllowAnyMethod.booleanValue()) {
                List<RfFunction> localFunctions = agent.getLocalFunctions();
                if (localFunctions != null) {
                    for (RfFunction function : localFunctions) {
                        visited.add(function);
                        function.visitHidObject(null, new IndirectFunctionVisitor(agent, visited));
                    }
                }
            } else {
                RfFunction buildPhase = agent.getFunctionWithPrefix(this.fOVMProject.getBuildPhaseMethodName(), 1, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
                if (buildPhase != null) {
                    visited.add(buildPhase);
                    buildPhase.visitHidObject(null, new IndirectFunctionVisitor(agent, visited));
                }
            }
            if (!this.configHid.isEmpty()) {
                this.addHit(agent, "Agent class " + LintUtils.getNamedElementFullName(agent) + " doesn't check that its virtual interface has been set!");
                this.configHid.clear();
            }
            this.checkedConfigHid.clear();
        }
    }

    public boolean checkPrewaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class IndirectFunctionVisitor
    implements IHidVisitor<IHidObject> {
        private RfClass classs;
        private Set<RfFunction> visited;
        private ParserPath parserPath;
        private IRfNamedElement scope;

        public IndirectFunctionVisitor(RfClass classs, Set<RfFunction> visited) {
            this.classs = classs;
            this.visited = visited;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.scope = ((HidHolder)holder).getScope();
            }
        }

        public boolean visit(IHidObject hidObject) {
            RfFunction tempFunction;
            if (!Check_R_1189.this.visiting) {
                return false;
            }
            if (Check_R_1189.this.checkPrewaivers(this.parserPath)) {
                return true;
            }
            String name = LintUtils.getFileShortName(this.parserPath.path);
            if (Check_R_1189.this.fOVMProject.isOVMFile(name)) {
                return true;
            }
            if (!(hidObject instanceof RfHid)) {
                return true;
            }
            RfHid hid = (RfHid)hidObject;
            if (this.findFatalMacro(hid)) {
                return false;
            }
            if (!hid.isMethodCall(false)) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            RfFunction function = (RfFunction)element;
            this.findGetMethod(hid);
            if (function.isPredefined()) {
                return true;
            }
            if (function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, hid, this.classs)) != null) {
                function = tempFunction;
            }
            if (this.visited.contains(function)) {
                return true;
            }
            this.visited.add(function);
            function.visitHidObject(null, new IndirectFunctionVisitor(this.classs, this.visited));
            return true;
        }

        private boolean findFatalMacro(RfHid hid) {
            block9: {
                if (Check_R_1189.this.configHid.isEmpty() && !Check_R_1189.this.pAllowAnyMethod.booleanValue()) {
                    return false;
                }
                IReparseInfo reparseInfo = hid.getReparseInfo();
                if (reparseInfo == null || !(reparseInfo instanceof ReparseInfo)) {
                    return false;
                }
                ReparseInfo.ReparseElement[] reparseStack = ((ReparseInfo)reparseInfo).getReparseStack();
                if (reparseStack == null || reparseStack.length == 0) {
                    return false;
                }
                if (reparseStack[0] == null || reparseStack[0].getReparseMacroName() == null) {
                    return false;
                }
                if (!reparseStack[0].getReparseMacroName().equals("uvm_fatal")) break block9;
                RfNamedElement scopeIterator = (RfNamedElement)this.scope;
                while (scopeIterator instanceof RfActionBlock) {
                    block10: {
                        RfHid vifHid;
                        IRfNamedElement element;
                        IHidObject vifObj;
                        block12: {
                            RfHidOperator equals;
                            block11: {
                                IHidObject conditionObj;
                                if (!(scopeIterator instanceof RfActionBlock) || !((RfActionBlock)scopeIterator).isIf() || (conditionObj = ((RfActionBlock)scopeIterator).getConditionalBlockExpression()) == null || !(conditionObj instanceof RfHidOperator) || !(equals = (RfHidOperator)conditionObj).isEquality()) break block10;
                                vifObj = equals.getLHValue();
                                if (equals.getFirstRHValue() != null && equals.getFirstRHValue() instanceof HidImplicit && ((HidImplicit)equals.getFirstRHValue()).getName().equals("null")) break block11;
                                if (equals.getLHValue() == null || !(equals.getLHValue() instanceof HidImplicit) || !((HidImplicit)equals.getLHValue()).getName().equals("null")) break block10;
                                vifObj = equals.getFirstRHValue();
                                break block12;
                            }
                            vifObj = equals.getLHValue();
                        }
                        if (vifObj != null && vifObj instanceof RfHid && (element = (vifHid = (RfHid)vifObj).getElement()) != null && element instanceof RfField && (((RfField)element).getDataType() == null || ((RfField)element).getDataType().isVirtualInterface()) && vifHid.getParentHid() != null && vifHid.getParentHid() instanceof RfHid) {
                            if (Check_R_1189.this.configHid.contains(vifHid.getParentHid())) {
                                Check_R_1189.this.configHid.clear();
                                Check_R_1189.this.visiting = false;
                            } else if (Check_R_1189.this.pAllowAnyMethod.booleanValue()) {
                                Check_R_1189.this.checkedConfigHid.add((RfHid)vifHid.getParentHid());
                            }
                            return true;
                        }
                    }
                    scopeIterator = scopeIterator.getEnclosingScope();
                }
            }
            return false;
        }

        private void findGetMethod(RfHid hid) {
            if (LintUtils.getHidFullName((IHid)hid).equals("uvm_pkg::uvm_config_db.get")) {
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                for (MethodCall call : methodCalls) {
                    if (call.argumentValuesMapRaw == null || call.argumentValuesMapRaw.isEmpty()) continue;
                    for (Map.Entry entry : call.argumentValuesMapRaw.entrySet()) {
                        IHidObject value;
                        RfField configField;
                        IRfNamedElement key = (IRfNamedElement)entry.getKey();
                        if (!(key instanceof RfField) || !(configField = (RfField)key).getName().equals("value") || (value = (IHidObject)entry.getValue()) == null || !(value instanceof RfHid)) continue;
                        RfHid valueHid = (RfHid)value;
                        IRfNamedElement valueElement = valueHid.getElement();
                        if (Check_R_1189.this.checkedConfigHid.contains((Object)valueHid)) {
                            Check_R_1189.this.configHid.clear();
                            Check_R_1189.this.visiting = false;
                            return;
                        }
                        if (valueElement == null || !(valueElement instanceof RfField) || LintUtils.getFieldFinalClassTypeOrNull((RfField)valueElement) == null) continue;
                        Check_R_1189.this.configHid.add((RfHid)value);
                    }
                }
            }
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

