/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="23.1.1")
@CheckID(value="R.1190")
@CheckName(value="R.1190")
@CheckLabel(labels={RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.SIGNAL})
@CheckTitle(value="Signal naming pattern")
@CheckDescription(value="This check flags signal names that match the pattern specified by the <namePattern> parameter.\nIn this context, a signal is meant to mean a net, variable, or port within a module, interface or program.\nBy default signal names should never end with an underscore followed by a number.\n\nCheck supports pre-waiving.")
public class Check_R_1190
extends OVMComplianceCheck {
    @CheckParameter(defaultValue=".*_[0-9]+", description="Only signals matching the specified pattern are flagged.", name="namePattern", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.REGEX)
    private Pattern pNamePatternValue;

    public Check_R_1190(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> blocks = new NullProtectedList<RfNamedElement>();
        blocks.addAll(this.fOVMProject.getAllInterfaces());
        blocks.addAll(this.fOVMProject.getAllModules());
        blocks.addAll(this.fOVMProject.getAllPrograms());
        for (RfNamedElement element : blocks) {
            RfDefElement declaration;
            if (element == null || !(element instanceof RfInterface) && !(element instanceof RfProgram) && !(element instanceof RfModule) || (declaration = element.getDeclaration()) == null || this.fOVMProject.getProjectWaivers().pathIsPrewaived(declaration.getParserPath(), this)) continue;
            this.notifyCheckAlive();
            List<? extends IRfNamedElement> signals = element.getAllSignals();
            if (signals == null || signals.isEmpty()) continue;
            for (IRfNamedElement iRfNamedElement : signals) {
                Matcher instanceNameMatcher;
                if (iRfNamedElement == null || !(iRfNamedElement instanceof RfField) || !(instanceNameMatcher = this.pNamePatternValue.matcher(iRfNamedElement.getName())).matches()) continue;
                this.addHit((RfNamedElement)iRfNamedElement, "Signal named '" + LintUtils.getNamedElementFullName((RfNamedElement)iRfNamedElement) + "' matches the naming pattern!");
            }
        }
    }
}

