/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.HashMap;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="23.1.7")
@CheckID(value="R.1191")
@CheckName(value="R.1191")
@CheckLabel(labels={RuleLabel.LITERAL_VALUE})
@CheckTitle(value="Do not use unsized literal expressions exceeding 32-bit integer range.")
@CheckDescription(value="\nThe type of an unsized literal expression is 32-bit integer. A 32-bit integer stores values between -2^31 (-2147483648) and +2^31-1 (2147483647).\nAs different simulators have different interpretations on the 2147483648 value, this rule checks that an unsized literal expression is between -2147483648 and 2147483647.\n\nCheck supports pre-waiving.")
public class Check_R_1191
extends OVMComplianceCheck {
    private Map<RfHidOperator, Number> expressionValueMap = new HashMap<RfHidOperator, Number>();

    public Check_R_1191(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HidOperatorVisitor expressionVisitor = new HidOperatorVisitor(null){

            public boolean visit(HidOperator hidOperator) {
                if (Check_R_1191.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                RfHidOperator expression = (RfHidOperator)hidOperator;
                if (!expression.isArithmetic() && !expression.isLogicalShift() && !expression.isArithmeticShift() || expression.isArithmeticAssignment() || expression.isLogicalAssignment()) {
                    return true;
                }
                Check_R_1191.this.notifyCheckAlive();
                this.evaluateExpression(expression);
                return true;
            }

            private void evaluateExpression(RfHidOperator expression) {
                Number rhNumber;
                Number lhNumber;
                int operatorType = expression.getOperatorType();
                IHidObject lh = expression.getLHValue();
                if (lh == null) {
                    return;
                }
                if (lh instanceof RfHidImplicit) {
                    RfHidImplicit lhPotentialValue = (RfHidImplicit)lh;
                    if (lhPotentialValue == null || this.isSizedLiteral(lhPotentialValue.getName())) {
                        return;
                    }
                    lhNumber = lhPotentialValue.parseNumberValue();
                } else if (lh instanceof RfHidOperator) {
                    lhNumber = Check_R_1191.this.expressionValueMap.get(lh);
                    if (lhNumber == null) {
                        return;
                    }
                } else {
                    return;
                }
                ListContainer rhValues = expression.getRHValues();
                if (rhValues == null || rhValues.isEmpty()) {
                    long lhValue;
                    if (lhNumber.toString().contains(".")) {
                        return;
                    }
                    long result = lhValue = lhNumber.longValue();
                    if (467 == operatorType) {
                        result = -lhValue;
                    } else if (465 == operatorType) {
                        result = lhValue;
                    } else {
                        return;
                    }
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        return;
                    }
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
                IHidObject rh = (IHidObject)rhValues.get(0);
                if (rh == null) {
                    return;
                }
                if (rh instanceof RfHidImplicit) {
                    RfHidImplicit rhPotentialValue = (RfHidImplicit)rh;
                    if (rhPotentialValue == null || this.isSizedLiteral(rhPotentialValue.getName())) {
                        return;
                    }
                    rhNumber = rhPotentialValue.parseNumberValue();
                } else if (rh instanceof RfHidOperator) {
                    rhNumber = Check_R_1191.this.expressionValueMap.get(rh);
                    if (rhNumber == null) {
                        return;
                    }
                } else {
                    return;
                }
                if (lhNumber == null || rhNumber == null) {
                    return;
                }
                if (lhNumber.toString().contains(".") || rhNumber.toString().contains(".")) {
                    return;
                }
                long lhValue = lhNumber.longValue();
                long rhValue = rhNumber.longValue();
                if (expression.isStar()) {
                    long result;
                    try {
                        result = Math.multiplyExact(rhValue, lhValue);
                    }
                    catch (ArithmeticException arithmeticException) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' exceeds 32-bit integer range!");
                        return;
                    }
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' exceeds 32-bit integer range!");
                        return;
                    }
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
                if (expression.isPowDoubleStar()) {
                    long result = (long)Math.pow(lhValue, rhValue);
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' exceeds 32-bit integer range!");
                        return;
                    }
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
                if (expression.isDiv()) {
                    long result;
                    try {
                        result = Math.floorDiv(lhValue, rhValue);
                    }
                    catch (ArithmeticException arithmeticException) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' includes a division by 0!");
                        return;
                    }
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
                if (expression.isPlus()) {
                    long result;
                    try {
                        result = Math.addExact(rhValue, lhValue);
                    }
                    catch (ArithmeticException arithmeticException) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' exceeds 32-bit integer range!");
                        return;
                    }
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' exceeds 32-bit integer range!");
                        return;
                    }
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
                if (expression.isMinus()) {
                    long result;
                    try {
                        result = Math.subtractExact(lhValue, rhValue);
                    }
                    catch (ArithmeticException arithmeticException) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' exceeds 32-bit integer range!");
                        return;
                    }
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' exceeds 32-bit integer range!");
                        return;
                    }
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
                if (expression.isLogicalShiftLeft() || expression.isArithmeticShiftLeft()) {
                    long limit = Integer.MAX_VALUE;
                    long result = lhValue << (int)rhValue;
                    if (lhValue < 0L) {
                        lhValue = -lhValue;
                        ++limit;
                    }
                    if ((double)rhValue > Math.log((double)limit / (double)lhValue) / Math.log(2.0)) {
                        Check_R_1191.this.addHit(this.parserPath, (HidOccurrence)expression.getOccurrence(), "Literal expression '" + expression.toString() + "' exceeds 32-bit integer range!");
                        return;
                    }
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
                if (expression.isLogicalShiftRight()) {
                    long result = lhValue >>> (int)rhValue;
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
                if (expression.isArithmeticShiftRight()) {
                    long result = lhValue >> (int)rhValue;
                    Check_R_1191.this.expressionValueMap.put(expression, result);
                    return;
                }
            }

            private boolean isSizedLiteral(String name) {
                int index = name.indexOf(39);
                return index > 0;
            }

            public void endScope(IRfNamedElement scope) {
                if (Check_R_1191.this.expressionValueMap != null) {
                    Check_R_1191.this.expressionValueMap.clear();
                }
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), (IHidVisitor<?>)expressionVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    @Override
    public void clean() {
        super.clean();
        if (this.expressionValueMap != null) {
            this.expressionValueMap.clear();
        }
    }
}

