/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckParametersOverrides;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractOverrideMethodFromParentClassCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="23.1.1")
@CheckID(value="R.1192")
@CheckName(value="R.1192")
@CheckLabel(labels={RuleLabel.RUN_PHASE, RuleLabel.OVERRIDE, RuleLabel.DRIVER, RuleLabel.MONITOR, RuleLabel.SUBSCRIBER, RuleLabel.SCOREBOARD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not override reset_phase, configure_phase, main_phase, shutdown_phase in drivers, monitors, subscribers, or scoreboards")
@CheckDescription(value="The run-time phase methods reset_phase, configure_phase, main_phase, shutdown_phase can be overridden to generate stimulus, typically by starting sequences.\nHowever this shouldn't be done in a driver, monitor, subscriber, or scoreboard component because these should be able to run regardless of the run-time phase.\nMaking any component explicitly phase-aware will in general restrict the possibilities for reuse.\n\nExamples\n\nclass my_driver extends uvm_driver;\n\tvirtual task reset_phase(uvm_phase phase); // not allowed\n  endtask\n\tvirtual task run_phase(uvm_phase phase); // allowed\n  endtask\nendclass\n\nCheck supports pre-waiving.")
@CheckParametersOverrides(value={@CheckParameterOverride(name="methodName", isVisible=false), @CheckParameterOverride(name="baseClass", isVisible=false), @CheckParameterOverride(name="skipBaseClasses", isVisible=false)})
public class Check_R_1192
extends AbstractOverrideMethodFromParentClassCheck {
    @CheckParameter(defaultValue="driver,monitor,subscriber,scoreboard", description="Comma separated list of UVM components. Classes extending the base classes associated with these components will be checked. The available components are: driver, monitor, subscriber, scoreboard", name="uvmComponents", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pUVMComponents;
    Set<String> uvmComponentsAllowedValues = new HashSet<String>(Arrays.asList("driver", "monitor", "subscriber", "scoreboard"));

    public Check_R_1192(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String componentName : this.pUVMComponents) {
            if (this.uvmComponentsAllowedValues.contains(componentName)) continue;
            this.signalParamError("Invalid value '" + componentName + "' for uvmComponents parameter!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        RfClass subscriberClass;
        HashSet<String> methodsName = new HashSet<String>();
        methodsName.addAll(Arrays.asList("reset_phase", "configure_phase", "main_phase", "shutdown_phase"));
        if (this.pUVMComponents.contains("driver") && this.fOVMProject.fOvmDriver != null) {
            this.checkOverrides(new HashSet<RfClass>(), this.fOVMProject.fOvmDriver.getChildren(), methodsName, null);
        }
        if (this.pUVMComponents.contains("monitor") && this.fOVMProject.fOvmMonitor != null) {
            this.checkOverrides(new HashSet<RfClass>(), this.fOVMProject.fOvmMonitor.getChildren(), methodsName, null);
        }
        if (this.pUVMComponents.contains("subscriber") && (subscriberClass = this.fOVMProject.getRfProject().getClass("uvm_pkg::uvm_subscriber", true)) != null) {
            this.checkOverrides(new HashSet<RfClass>(), subscriberClass.getChildren(), methodsName, null);
        }
        if (this.pUVMComponents.contains("scoreboard") && this.fOVMProject.fOvmScoreboard != null) {
            this.checkOverrides(new HashSet<RfClass>(), this.fOVMProject.fOvmScoreboard.getChildren(), methodsName, null);
        }
    }

    @Override
    public void computeHitForMethod(RfClass aClass, String aMethodName, RfFunction implementedMethod) {
        if (implementedMethod != null) {
            this.addHit(implementedMethod, "Class '" + aClass.getName() + "' overrides '" + aMethodName + "()' !");
        }
    }
}

