/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;

@CheckVersion(value="23.1.2")
@CheckID(value="R.1193")
@CheckName(value="R.1193")
@CheckLabel(labels={RuleLabel.FILE, RuleLabel.CONDITIONAL_DIRECTIVE, RuleLabel.INCLUDE_GUARD})
@CheckTitle(value="Do not have include statements guarded by `ifdef/`ifndef")
@CheckDescription(value="This check flags `include statements guarded by active or inactive `ifdef/`ifndef directives as this way of handling compiled files is difficult to maintain and understand.\nTo give users control on which files to compile or not, `ifndef guards should enclose the entire file, this way defines can be used in the build config file for files that should not be included.\n\nExample:\n`ifndef A\n    `include \"file.sv\";  // NOT ALLOWED\n`endif\n\nCheck supports pre-waiving.")
public class Check_R_1193
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final String INCLUDE = "`include";

    public Check_R_1193(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        Map<ParserPath, List<LintUtils.DirectiveInfo>> allDirectives = LintUtils.getAllDirectives(this.fOVMProject.getAllFilesInOrder(), this.fOVMProject.getRfProject().getPreprocessingTable(), this.getWSParser());
        for (ParserPath path : this.fOVMProject.getAllImportedFiles()) {
            Map<Integer, LiteralToken> tokens;
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(path, this)) continue;
            this.notifyCheckAlive();
            List<LintUtils.DirectiveInfo> directivesInFile = allDirectives.get(path);
            if (directivesInFile == null || directivesInFile.isEmpty() || (tokens = this.getWSParser().getTokens(path)) == null) continue;
            LinkedList<LiteralToken> literalTokens = new LinkedList<LiteralToken>(tokens.values());
            int i = 0;
            while (i < literalTokens.size()) {
                String currentString;
                LiteralToken token = (LiteralToken)literalTokens.get(i);
                if (token.getZone() == SVTBWhitespaceParser.ZoneType.CODE && (currentString = token.getStringToken()).length() >= INCLUDE.length() && currentString.substring(0, INCLUDE.length()).equals(INCLUDE)) {
                    for (LintUtils.DirectiveInfo directive : directivesInFile) {
                        if (directive.getStartOffset() >= token.getOffsetFile() || token.getOffsetFile() >= directive.getEndOffset()) continue;
                        this.addHit(path, token, directive);
                    }
                }
                ++i;
            }
        }
    }

    private void addHit(ParserPath path, LiteralToken token, LintUtils.DirectiveInfo directive) {
        this.addHit(path, token.getLineNumber(), "Forbidden include statement inside '`" + directive.getDirectiveType() + " " + directive.getDirectiveArg() + "' guard!", null);
    }
}

