/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="23.1.2")
@CheckID(value="R.1194")
@CheckName(value="R.1194")
@CheckLabel(labels={RuleLabel.BANNED_API, RuleLabel.PREDEFINED_METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use $test$plusargs and $value$plusargs with strings containing uvm")
@CheckDescription(value="Do not use keywords UVM or uvm for command line arguments as they may be used in the future for library specific arguments.\n\nExample:\n$test$plusargs(\"uvm\");        // NOT ALLOWED\n$value$plusargs(\"UVM\", obj);  // NOT ALLOWED\n\nCheck supports pre-waiving.")
public class Check_R_1194
extends OVMComplianceCheck {
    private static final String VALUE_PLUSARGS = "$value$plusargs";
    private static final String TEST_PLUSARGS = "$test$plusargs";

    public Check_R_1194(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hid) {
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                if (Check_R_1194.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                Check_R_1194.this.notifyCheckAlive();
                IRfNamedElement element = hid.getElement();
                if (!(element instanceof RfPredefinedFunction)) {
                    return true;
                }
                RfPredefinedFunction function = (RfPredefinedFunction)element;
                if (!function.getName().equals(Check_R_1194.VALUE_PLUSARGS) && !function.getName().equals(Check_R_1194.TEST_PLUSARGS)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                if (methodCalls == null || methodCalls.isEmpty()) {
                    return true;
                }
                for (MethodCall methodCall : methodCalls) {
                    for (Map.Entry entry : methodCall.argumentValuesMapRaw.entrySet()) {
                        RfHidImplicit value;
                        String actualValue;
                        IRfNamedElement key = (IRfNamedElement)entry.getKey();
                        if (!"arg_name".equals(key.getName()) && !"user_string".equals(key.getName()) || !(entry.getValue() instanceof RfHidImplicit) || !(actualValue = (value = (RfHidImplicit)entry.getValue()).getName()).toUpperCase().contains("UVM")) continue;
                        Check_R_1194.this.addHit(this.parserPath, hid, "Forbidden '" + HidUtils.toNiceString((IHidObject)hid) + "' call with argument containing 'UVM': " + actualValue + "'!");
                    }
                }
                return true;
            }
        });
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

