/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;

@CheckVersion(value="23.1.3")
@CheckID(value="R.1195")
@CheckName(value="R.1195")
@CheckLabel(labels={RuleLabel.PACKAGE, RuleLabel.CLASS})
@CheckTitle(value="Declare package for specified children of base classes")
@CheckDescription(value="For each of the specified base classes, this rule checks that their children are declared in packages.\nExtending a base class is valid if at least one child is declared in a package and in that package there are no other children from the other base classes.\n\nExample when 'baseClasses' is 'baseClass1, baseClass2, baseClass3'\nFor the following children declarations, only the childClass1 is valid.\n\npackage p1;\n  class childClass1 extends baseClass1;\n  endclass\nendpackage\n\npacakge p2;\n  class childClass2 extends baseClass2;\n  endclass\n  class childClass3 extends baseClass3;\n  endclass\nendpackage")
@CheckReapplyDisable
public class Check_R_1195
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of base class full names to be checked.", name="baseClasses", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBaseClasses = new HashSet();
    private HashSet<RfClass> baseClasses;
    private Map<RfPackage, Set<RfClass>> classPackages;

    public Check_R_1195(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.classPackages = new HashMap<RfPackage, Set<RfClass>>();
        this.baseClasses = new HashSet();
        for (String baseClass : this.pBaseClasses) {
            RfClass clazz = this.fOVMProject.getRfProject().getClass(baseClass, true);
            if (clazz == null) {
                this.signalParamError("Class named " + baseClass + " for was not found!", false);
                continue;
            }
            Set<RfClass> childClass = clazz.getChildren();
            if (childClass == null || childClass.isEmpty()) {
                this.addHit(new ParserPath("none"), 0, "Base class " + LintUtils.getNamedElementFullName(clazz) + " doesn't have any children classes!", null);
                continue;
            }
            this.notifyCheckAlive();
            this.baseClasses.add(clazz);
            for (RfClass rfClass : childClass) {
                RfNamedElement scope = rfClass.getEnclosingScope();
                if (!(scope instanceof RfPackage)) continue;
                RfPackage rfPackage = (RfPackage)scope;
                if (this.classPackages.containsKey(rfPackage)) {
                    this.classPackages.get(rfPackage).add(clazz);
                    continue;
                }
                this.classPackages.put(rfPackage, new HashSet<RfClass>(Arrays.asList(clazz)));
            }
        }
        for (RfClass clazz : this.baseClasses) {
            this.notifyCheckAlive();
            boolean found = false;
            for (Map.Entry<RfPackage, Set<RfClass>> classPack : this.classPackages.entrySet()) {
                if (classPack.getValue().size() != 1 || !classPack.getValue().contains(clazz)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.addHit(new ParserPath("none"), 0, "Base class " + LintUtils.getNamedElementFullName(clazz) + " doesn't have at least one child in a package!", null);
        }
    }
}

